#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: App.py 11517 2019-05-03 12:53:40Z Andy $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Andy $ (last)
# $Date: 2019-05-03 20:53:40 +0800 (Fri, 03 May 2019) $
# $Revision: 11517 $


 
import os
 
from celery import Celery
 
from Iuppiter import Configure

settings = Configure.getSettings()

if settings is None:
    projectName = os.getcwd().split(os.sep)[-1]
    app = Celery(projectName)

else:
    projectName = settings.strip('.settings')

    if not projectName:
        projectName = os.getcwd().split(os.sep)[-1]

    if 'DJANGO_SETTINGS_MODULE' not in os.environ:
        os.environ.setdefault('DJANGO_SETTINGS_MODULE', settings)

    app = Celery(projectName, strict_typing=False)
    app.config_from_object(settings)
