#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: Backends.py 12940 2021-06-03 15:19:56Z Lavender $
#
# Copyright (c) 2021 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2021-06-03 23:19:56 +0800 (Thu, 03 Jun 2021) $
# $Revision: 12940 $

import re
import os
import sys
import json
import requests

from passlib.apache import HtpasswdFile

from django.conf import settings
from django.contrib.auth.backends import ModelBackend
from django.contrib.auth.models import User

DEFAULT_TRAC_AUTH_URL = getattr(settings, 
    'DEFAULT_TRAC_AUTH_URL', 'https://code.nuwainfo.com/aec359bc3cfadb7504f26461a4c06625')
DEFAULT_TRAC_AUTH_USERNAME = getattr(settings, 'DEFAULT_TRAC_AUTH_USERNAME', 'Deploy')
DEFAULT_TRAC_AUTH_PASSWORD = getattr(settings, 'DEFAULT_TRAC_AUTH_PASSWORD', 'ei0W1aUeP1pcRvJoV4X8ZC2xm')
SET_TRAC_LOGIN_AS_STAFF = getattr(settings, "SET_TRAC_LOGIN_AS_STAFF", False)
SET_TRAC_LOGIN_AS_SUPERUSER = getattr(settings, "SET_TRAC_LOGIN_AS_SUPERUSER", False)

USER_DATA_PATTERN = "#\s+?(\w+):\s+?(\{.+\}?)"
  
class TracBackend(ModelBackend):

    def check(self, username, password, tracAuthURL=DEFAULT_TRAC_AUTH_URL, 
        tracUsername=DEFAULT_TRAC_AUTH_USERNAME, tracPassword=DEFAULT_TRAC_AUTH_PASSWORD):
        r = requests.get(tracAuthURL, auth=(tracUsername, tracPassword))
        content = r.text.strip()
        prog = re.compile(USER_DATA_PATTERN)
        data = {g[0]: json.loads(g[1]) for g in prog.findall(content)}
        ht = HtpasswdFile.from_string(content)
        if not data.get(username, {}).get("email"):
            raise RuntimeError("No email in htfile for %s" % username)
        else:
            email = data.get(username, {}).get("email")
        if ht.check_password(username, password):
            return (True, email)

        return (False, None)

    def authenticate(self, request, username=None, password=None):
        valid, email = self.check(username, password)
        if valid:
            try:
                user = User.objects.get(username=username)
            except User.DoesNotExist:
                # Create a new user. There's no need to set a password
                user = User(username=username, email=email)
                user.is_staff = SET_TRAC_LOGIN_AS_STAFF
                user.is_superuser = SET_TRAC_LOGIN_AS_SUPERUSER
                user.save()
            return user
        return None