#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: models.py 11142 2018-07-07 13:50:30Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2018-07-07 22:50:30 +0900 (週六, 07 七月 2018) $
# $Revision: 11142 $

from functools import wraps
from django import forms
from django.db import models
from django.conf import settings
from django.utils.translation import ugettext_lazy as _
from cms.models import CMSPlugin
from aldryn_categories.models import Category
from aldryn_newsblog.models import Article
from taggit.models import Tag

from Zephyrus.blog_extension import settings as _settings

METHODS = [
    ('or',  _('OR')),
    ('and',  _('AND')),
]

class FilterPlugin(CMSPlugin):
    limit = models.PositiveIntegerField(_('Limit'), default=6)

    filterMethod = models.CharField(
        _('Filter Method'), max_length=3, choices=METHODS, default='or')

    tag = models.ManyToManyField(
        Tag,
        verbose_name=_('Tag'),
        default=None,
        blank=True,
        null=True,
    )

    catagory = models.ForeignKey(
        Category,
        verbose_name=_('Catagory'),
        on_delete=models.CASCADE,
        related_name='+',
        default=None,
        blank=True,
        null=True,
    )

    renderTemplate = models.CharField(
        _('Render template'), max_length=150,
        choices=_settings.ZEPHYRUS_BLOG_MAYLIKE_TEMPLATES,
        default=_settings.ZEPHYRUS_BLOG_MAYLIKE_DEFAULT_TEMPLATE,
    )


# modify slug field formfield
def formfieldDecorator(f):
    @wraps(f)
    def wrapper(*args, **kwds):
        return f(form_class=forms.CharField ,*args, **kwds)
    return wrapper

for field in Article.translations.related.related_model._meta.fields:
    if field.attname == 'slug':
        field.default_validators = []
        field.validators = []
        field.formfield = formfieldDecorator(field.formfield)

for field in Category.translations.related.related_model._meta.fields:
    if field.attname == 'slug':
        field.default_validators = []
        field.validators = []
        field.formfield = formfieldDecorator(field.formfield)

for field in Tag._meta.fields:
    if field.attname == 'slug':
        field.default_validators = []
        field.validators = []
        field.formfield = formfieldDecorator(field.formfield)


