#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: admin.py 11069 2018-05-21 10:18:52Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2018-05-21 18:18:52 +0800 (週一, 21 五月 2018) $
# $Revision: 11069 $

from django.conf.urls import url
from django.utils.http import urlquote  as django_urlquote
from django.views.generic.detail import DetailView
from django.http import (
    HttpResponseRedirect,
    HttpResponsePermanentRedirect,
)

from cms import cms_toolbars

from menus.utils import set_language_changer

from aldryn_newsblog import views
from aldryn_newsblog.views import (
    ArticleDetail, CategoryArticleList, TagArticleList)

class ArticleDetail2(ArticleDetail):
    def get(self, request, *args, **kwargs):
        if not hasattr(self, 'object'):
            self.object = self.get_object()
            
        set_language_changer(request, self.object.get_absolute_url)
        url = self.object.get_absolute_url()
       
        if (self.config.non_permalink_handling == 200 or 
            django_urlquote(request.path) == url):
            return super(ArticleDetail, self).get(request, *args, **kwargs)

        if self.config.non_permalink_handling == 302:
            return HttpResponseRedirect(url)
        elif self.config.non_permalink_handling == 301:
            return HttpResponsePermanentRedirect(url)
        else:
            raise Http404('This is not the canonical uri of this object.')
            
    # 以下兩個一定要貼，不然會 maximum recursion depth exceeded in cmp
    def get_object(self, queryset=None):
        if queryset is None:
            queryset = self.get_queryset()

        slug = self.kwargs.get(self.slug_url_kwarg, None)
        pk = self.kwargs.get(self.pk_url_kwarg, None)
        
        if pk is not None:
            return DetailView.get_object(self, queryset=queryset)
        elif slug is not None:
            return super(ArticleDetail, self).get_object(queryset=queryset)

        raise AttributeError('ArticleDetail view must be called with either '
                             'an object pk or a slug')
    
    def get_context_data(self, **kwargs):
        context = super(ArticleDetail, self).get_context_data(**kwargs)
        context['prev_article'] = self.get_prev_object(
            self.queryset, self.object)
        context['next_article'] = self.get_next_object(
            self.queryset, self.object)
        return context
    
views.ArticleDetail = ArticleDetail2

from aldryn_newsblog.urls import urlpatterns
from aldryn_newsblog.feeds import TagFeed, CategoryFeed

urlpatterns += [
    url(r'^(?P<slug>.*)/$',
        ArticleDetail2.as_view(), name='article-detail'),
    url(r'^(?P<year>\d{4})/(?P<slug>.*)/$',
        ArticleDetail2.as_view(), name='article-detail'),
    url(r'^(?P<year>\d{4})/(?P<month>\d{1,2})/(?P<slug>.*)/$',
        ArticleDetail2.as_view(), name='article-detail'),
    url(r'^(?P<year>\d{4})/(?P<month>\d{1,2})/(?P<day>\d{1,2})/(?P<slug>.*)/$',
        ArticleDetail2.as_view(), name='article-detail'),

    url(r'^category/(?P<category>.*)/$',
        CategoryArticleList.as_view(), name='article-list-by-category'),
    url(r'^category/(?P<category>.*)/feed/$',
        CategoryFeed(), name='article-list-by-category-feed'),

    url(r'^tag/(?P<tag>.*)/$',
        TagArticleList.as_view(), name='article-list-by-tag'),
    url(r'^tag/(?P<tag>.*)/feed/$',
        TagFeed(), name='article-list-by-tag-feed'),
]