#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: models.py 11055 2018-05-14 09:46:32Z Lavender $
#
# Copyright (c) 2018 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $ (last)
# $Date: 2018-05-14 17:46:32 +0800 (週一, 14 五月 2018) $
# $Revision: 11055 $

from django.db import models

from cms.models import CMSPlugin
from oscar.core.loading import get_model
# from taggit.models import Tag

from Zephyrus.cms_oscar import settings

Category = get_model('catalogue', 'category')

class OscarFeatured(CMSPlugin):
    limit = models.PositiveIntegerField(default=6)

    renderTemplate = models.CharField(
        'Featured Template', max_length=150, blank=True,
        choices=settings.ZEPHYRUS_OSCAR_FEATURED_TEMPLATES,
        default=settings.ZEPHYRUS_OSCAR_FEATURED_DEFAULT_TEMPLATE,
    )
    
    tag = models.IntegerField(
        default=None,
        blank=True,
        null=True,
    )

    catagory = models.ForeignKey(
        Category,
        on_delete=models.CASCADE,
        related_name='+',
        default=None,
        blank=True,
        null=True,
    )
    
class OscarLatest(CMSPlugin):
    limit = models.PositiveIntegerField(default=6)

    renderTemplate = models.CharField(
        'Latest Template', max_length=150, blank=True,
        choices=settings.ZEPHYRUS_OSCAR_LATEST_TEMPLATES,
        default=settings.ZEPHYRUS_OSCAR_LATEST_DEFAULT_TEMPLATE,
    )

    tag = models.IntegerField(
        default=None,
        blank=True,
        null=True,
    )
    
    catagory = models.ForeignKey(
        Category,
        on_delete=models.CASCADE,
        related_name='+',
        default=None,
        blank=True,
        null=True,
    )