#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: views.py 11055 2018-05-14 09:46:32Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2018-05-14 17:46:32 +0800 (週一, 14 五月 2018) $
# $Revision: 11055 $

from django.views.generic import View
from django.shortcuts import redirect, get_object_or_404

from Zephyrus.comment.models import Comment

class CommentView(View):  
    def post(self, request, *args, **kwargs):
        url = request.POST.get('url')
        message = request.POST.get('message')
        if request.user.is_anonymous():
            email = request.POST.get('email')
            comment = Comment(
                url=url,
                user=None,
                email=email,
                message=message,
            )
        else:
            user = request.user
            comment = Comment(
                url=url,
                user=user,
                email=None,
                message=message,
            )
        comment.save()
        return redirect(url)