#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: urls.py 10838 2018-03-12 10:54:45Z David $
#
# Copyright (c) 2012 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: David $
# $Date: 2018-03-12 18:54:45 +0800 (Mon, 12 Mar 2018) $
# $Revision: 10838 $

from django.conf.urls import url, include, patterns
from django.conf import settings

from Theophrastus import views

urlpatterns = patterns('', 
    # django-selectable.
    url(r'^newsletters/selectable/', include('selectable.urls')),
    url(r'^tracking/historic/(?P<slug>[-\w]+)/$', views.viewNewsletterHistoric,
        name='newsletter_newsletter_historic'),
    
    # api 統合其他 app 的 api url
    url(r'^api/', include('Theophrastus.api.urls')),
)

# Newsletter_extension
if 'Theophrastus.newsletter_extension' in settings.INSTALLED_APPS:
    urlpatterns += (
        url(r'^newsletter/', 
            include('Theophrastus.newsletter_extension.urls')),
    )

# emencia.django.newsletter
urlpatterns += (
    url(r'^newsletter/', include('emencia.django.newsletter.urls')),
)    

# Editor.
if 'Theophrastus.editor' in settings.INSTALLED_APPS:
    urlpatterns += (
        url(r'^', include('emencia.django.newsletter.urls')),
        url(r'^plus/editor/', include('Theophrastus.editor.urls')),
    )

# Statistics. 
# Subscribers.
if 'Theophrastus.statistics' in settings.INSTALLED_APPS:
    urlpatterns += (
        url(r'^statistics/', 
            include('Theophrastus.statistics.urls.statistics')),
        url(r'^subscribers/',
            include('Theophrastus.statistics.urls.subscribers')),
    )

# Integration
if 'Theophrastus.integration' in settings.INSTALLED_APPS:
    urlpatterns += (
        url(r'^integration/', include('Theophrastus.integration.urls')),
    )  

# Cloud.
if 'Theophrastus.cloud' in settings.INSTALLED_APPS:
    urlpatterns += (
        url(r'^plus/cloud/', include('Theophrastus.cloud.urls')),
    )   

# Documents
if 'Theophrastus.document' in settings.INSTALLED_APPS:
    urlpatterns += (
        url(r'^admin/', include('Theophrastus.document.urls')),
    )   


    
    


