#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: ServiceTest.py 9439 2015-09-25 08:01:30Z Eric $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Eric $ (last)
# $Date: 2015-09-25 16:01:30 +0800 (Fri, 25 Sep 2015) $
# $Revision: 9439 $

from django.test import TestCase

from Iuno.member import service

member = service.AbstractMemberService.getInstance()

class TestUser(TestCase):
    
    def setUp(self):
        
        member.createUser(username='john',
                          email='lennon@thebeatles.com',
                          password='johnpassword')
        
    def testUserHandler(self):

        ifUserExist = member.checkUserExist(username='john')
        self.assertTrue(ifUserExist)        


        user = member.getUser(username='john')
        self.assertEqual(user.email, 'lennon@thebeatles.com')
        
        
        member.updateUser(user, email='test@example.com')
        self.assertEqual(member.getUser(username='john').email, 
                         'test@example.com')
        
        
        member.deleteUser(username='john')
        ifUserExist = member.checkUserExist(username='john')
        self.assertFalse(ifUserExist)
        