#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: get_template.py 9978 2017-05-20 15:24:37Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-05-20 23:24:37 +0800 (週六, 20 五月 2017) $
# $Revision: 9978 $

import os
import logging
import shutil

from django.core.management.base import BaseCommand, CommandError

from Zephyrus.boilerplate.management.commands import (
    TEMPLATES_DIR_PATH, STATIC_DIR_PATH, IMAGES_DIR_PATH, ROOT_DIR_PATH)

logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)
handler = logging.StreamHandler()
handler.setFormatter(
    logging.Formatter("%(asctime)s - %(levelname)s - %(message)s"))
logger.addHandler(handler)

class Command(BaseCommand):

    help = 'Copy html to templates and copy static files to static.'
    args = '<destination folder>'

    def handle(self, *args, **options):
        if len(args) < 1:
            raise CommandError(
                "You must specify a folder to get template."
                )

        path = args[0]

        try:
            shutil.rmtree(TEMPLATES_DIR_PATH)
            logger.info("Remove Temeplates folder.")
        except Exception as e:
            logger.error("Temeplates folder is not exist.")
            os.mkdir(TEMPLATES_DIR_PATH)
        else:
            os.mkdir(TEMPLATES_DIR_PATH)
            logger.info("Create Temeplates folder.")

        try:
            shutil.rmtree(STATIC_DIR_PATH)
            logger.info("Remove static folder.")
        except Exception as e:
            logger.error("Static folder is not exist.")
            os.mkdir(STATIC_DIR_PATH)
        else:
            os.mkdir(STATIC_DIR_PATH)
            logger.info("Create static folder.")
            
        try:
            shutil.rmtree(IMAGES_DIR_PATH)
            logger.info("Remove images folder.")
        except Exception as e:
            logger.error("Images folder is not exist.")
            

        logger.info("-----Start copy templates-----")
        
        imgPath = os.path.join(path, 'images')
        shutil.copytree(imgPath, IMAGES_DIR_PATH)
        logger.info("Copy images folder to root.")


        for root, dirs, files in os.walk(path):
            if 'info.json' in files:
                jsonPath = os.path.join(root, 'info.json')           
                jsonDst = os.path.join(ROOT_DIR_PATH, 'info.json')
                shutil.copyfile(jsonPath, jsonDst)
                logger.info('Copy %s to root.' % 'info.json')

            if "index.html" in files or "Index.html" in files:
                for fileName in files:
                    filePath = os.path.join(root, fileName)
                    if fileName.endswith('.html'):
                        dst = os.path.join(TEMPLATES_DIR_PATH, fileName)
                        shutil.copyfile(filePath, dst)
                        logger.info(
                            'Copy %s to templates folder.' % fileName)
                    else:
                        dst = os.path.join(STATIC_DIR_PATH, fileName)
                        shutil.copyfile(filePath, dst)
                        logger.info('Copy %s to static folder.' % fileName)
                for dirName in dirs:
                    dirPath = os.path.join(root, dirName)
                    dst = os.path.join(STATIC_DIR_PATH, dirName)
                    shutil.copytree(dirPath, dst)
                    logger.info('Copy %s to static folder.' % dirName)
                break

        logger.info('-----All OK!-----')