#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: TemplateEditor.py 11172 2018-07-16 09:31:00Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2018-07-16 17:31:00 +0800 (週一, 16 七月 2018) $
# $Revision: 11172 $

import os
import datetime

from django import template

register = template.Library()

def getFileData(node, dataName):
    fullPath = node.absolutePath

    if dataName == 'mtime':
        return datetime.datetime.fromtimestamp(os.stat(fullPath).st_mtime)
    elif dataName == 'size':
        return os.stat(fullPath).st_size
    else:
        return None

register.filter('getFileData', getFileData)
