#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: models.py 10040 2017-06-11 08:28:26Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-06-11 16:28:26 +0800 (週日, 11 六月 2017) $
# $Revision: 10040 $

from django.db import models
from django.utils import timezone
from django.utils.translation import ugettext_lazy as _

class AdminPlaceholder(models.Model):
    name = models.CharField(_("Name"), max_length=20, editable=False, null=True)
    fromUrl = models.CharField(max_length=100, editable=False, null=True)
    page = models.ForeignKey(
        'cms.Page',
        on_delete=models.CASCADE,
        editable=False,
        default=None,
        null=True,
    )
    text = models.TextField(_("Text"))
    useGlobalAdminPlaceholder = models.BooleanField(
        _("Use Global AdminPlaceholder Value"), default=False)
        
    def __unicode__(self):
        return u"AdminPlaceholder: %d" % (self.id,)
        
        
class BlockDisplayControl(models.Model):
    name = models.CharField(_("Name"), max_length=20, editable=False, null=True)
    fromUrl = models.CharField(max_length=100, editable=False, null=True)
    page = models.ForeignKey(
        'cms.Page',
        on_delete=models.CASCADE,
        editable=False,
        default=None,
        null=True
    )
    display = models.BooleanField(_("Display"), default=True)
    useGlobalBlockDisplayControl = models.BooleanField(
        _("Use Global BlockDisplayControl Value"), default=False)
        
    def __unicode__(self):
        return u"BlockDisplayControl: %d" % (self.id,)
