#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: views.py 9754 2017-02-18 05:34:31Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-02-18 13:34:31 +0800 (週六, 18 二月 2017) $
# $Revision: 9754 $

from django import template
from django.utils.safestring import mark_safe

register = template.Library()

@register.simple_tag
def RenderLandingIuput(request, redirectTo=None, **kwargs):
    attrStr = ''
   
    for k in kwargs:
        attrStr += " %s='%s'" % (k, kwargs[k]) 
    
    fromUrlInput = \
        "<input type='hidden' name='fromUrl' value='%s'/>" % request.path

    emailInput = ("<input name='email' type='email' required='required' "
                  "%s/>" % attrStr)
    
    if redirectTo:
        redirectToInput = (
            "<input name='redirectTo' type='hidden' value='%s' />" % redirectTo)
        return mark_safe(fromUrlInput + emailInput + redirectToInput)
    else:
        return mark_safe(fromUrlInput + emailInput)
