#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: 0001_initial.py 13189 2021-08-04 10:31:25Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2021-08-04 18:31:25 +0800 (Wed, 04 Aug 2021) $
# $Revision: 13189 $

from __future__ import unicode_literals

from django.db import migrations, models
from django.conf import settings

if hasattr(settings, 'ZEPHYRUS_BLOG_ENABLE'):
    ZEPHYRUS_BLOG_ENABLE = settings.ZEPHYRUS_BLOG_ENABLE
else:
    ZEPHYRUS_BLOG_ENABLE = False

def moveViewCount(apps, schemaEditor):
    try:
        # 如果有 blog_extension.models.ViewCount
        ViewCount = apps.get_model('blog_extension', 'ViewCount')
    except:
        # do nothing
        return
    
    URL = apps.get_model('stats', 'URL')
    for vc in ViewCount.objects.all():
        url, created = URL.objects.get_or_create(
            url=vc.url,
        )
        url.viewCount=vc.count
        url.save()


class Migration(migrations.Migration):

    if ZEPHYRUS_BLOG_ENABLE:
        dependencies = [
            ('blog_extension', '0008_auto_20190522_0409'),
        ]
    else:
        dependencies = [
        ]

    operations = [
        migrations.CreateModel(
            name='URL',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, 
                                        auto_created=True, primary_key=True)),
                ('url', models.CharField(max_length=400, editable=False)),
                ('viewCount', models.PositiveIntegerField(default=0)),
                ('likeCount', models.PositiveIntegerField(default=0)),
                ('commentCount', models.PositiveIntegerField(default=0)),
            ],
        ),
        migrations.RunPython(moveViewCount),
    ]
