#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: setup.py 13447 2022-05-09 07:39:50Z Jason $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Jason $ (last)
# $Date: 2022-05-09 15:39:50 +0800 (Mon, 09 May 2022) $
# $Revision: 13447 $

from Zephyrus.Version import ZEPHYRUS_VERSION
import os
import re

try:
    from Iuppiter.DistUtil import setup
except ImportError:
    iuppiter = 'Iuppiter'
    with open('REQUIREMENTS.txt') as f:
        lines = f.readlines()
    for line in lines:
        if re.match(f'^{iuppiter}[>=<]=?', line):
            iuppiter = line
            break
            
    os.system(f'pip install {iuppiter} --no-cache-dir')
    from Iuppiter.DistUtil import setup

setup(
    'Zephyrus',
    description="Django CMS related packages for Nuwa Information Ltd.",
    version=ZEPHYRUS_VERSION,
    license='Proprietary License',
    author='Lavendar',
    author_email='lavendar.chan@nuwainfo.com',
    url='http://www.nuwainfo.com/',
    extrasRequire={
        'shop': "REQUIREMENTS_SHOP.txt",
    },
)
