#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: SearchForm.py 9653 2016-04-27 06:09:22Z Judy $
#
# Copyright (c) 2013 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Judy $
# $Date: 2016-04-27 14:09:22 +0800 (Wed, 27 Apr 2016) $
# $Revision: 9653 $

from django.template import Library

from django.contrib.admin.views.main import SEARCH_VAR

from Theophrastus.integration.admin import AppChangeList, GroupChangeList
from Theophrastus.integration.admin import NewsletterIntegrationChangeList
from Theophrastus.integration.admin import MailingListChangeList

register = Library()

@register.inclusion_tag('admin/SearchForm.html')
def searchForm(cl):
    """
    Displays a search form for searching the list.

    We modify their(Newsletter, Group and App) change list view, to let
    result_count the same full_result_count.
    """
    
    response = {
        'cl': cl,
        'show_result_count': cl.result_count != cl.full_result_count,
        'search_var': SEARCH_VAR
    }

    totalCount = None
    originaLink = ''
    if isinstance(cl, GroupChangeList):
        if cl._app:
            originaLink = 'app=%s' % str(cl._app)
        totalCount = cl.getQuerySet(original=True).count()
    elif isinstance(cl, AppChangeList):
        originaLink = ''
        totalCount = cl.model.objects.filter(user=cl._user).count()
    elif isinstance(cl, NewsletterIntegrationChangeList):
        if cl._group:
            originaLink = 'group=%s' % str(cl._group)
        totalCount = cl.getQuerySet(original=True).count()
    elif isinstance(cl, MailingListChangeList):
        totalCount = cl.getQuerySet(original=True).count()

    if not totalCount is None:
        response.update({
            'toggle': True,
            'originaLink': originaLink,
            'originalCount': totalCount,
            'show_result_count': cl.result_count != totalCount
        })
    return response
