#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: MailTest.py 9655 2016-04-27 09:49:28Z Judy $
#
# Copyright (c) 2016 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Judy $
# $Date: 2016-04-27 17:49:28 +0800 (Wed, 27 Apr 2016) $
# $Revision: 9655 $

import os
import json
import time
import threading

from urllib import urlopen, urlencode

from Iuppiter import test as TestUtil
from Iuppiter.Encoding import utf8
from Iuppiter.test.Web import runTestServer

# from Theophrastus import tests

import unittest

SERVER_DOMAIN = 'http://localhost:7788'
fileDir = os.path.dirname(os.path.abspath(__file__))
TARGET_PATH = os.path.abspath(
                os.path.join(fileDir, os.pardir, os.pardir, 'tests/Project/'))

class MailerTest(unittest.TestCase):

    def _testCheckStatus(self):
        """
        Test for mailer retry newsletter when newsletter waiting for too long
        or newsletter should be canceled if it failed too much.
        
        The test will fail, the ticket of this testcase:
        https://code.nuwainfo.com/trac/mercurius/ticket/2752
        """

        with runTestServer(path=TARGET_PATH, settings='Project.settings', 
                           port=7788,
                           fixtures=['initial_data', 'test'],
                           noInput=True, timeout=90):
            urlopen('%s/' % SERVER_DOMAIN)
            
            time.sleep(90)
            # Case 1.
            _info = urlopen('%s/newsletters/api/newsletter/?id=%d' %
                            (SERVER_DOMAIN, 1))
            _info = json.loads(_info.read())
            condition = (_info['status'] == 5) and (_info['id'] == 1)
            self.assertTrue(condition)

            # Case 2.
            _info = urlopen('%s/newsletters/api/newsletter/?id=%d' %
                            (SERVER_DOMAIN, 2))
            _info = json.loads(_info.read())
            condition = (_info['status'] == 4) and (_info['id'] == 2)
            self.assertTrue(condition)

    def testMailerWithLargeContent(self):
        """
        Test for send mail by large content.
        """
        results = []
  
        def _doSend(domain):
  
            # Login.
            loginData = urlencode({
                'user': 'admin', 'pwd': 'admin', 'app': 'Test large mail'})
            _re = urlopen('%s/newsletters/api/app/login/' % domain, loginData)
            _re = json.loads(_re.read())
            print _re
            token = _re['token']
  
            # Create newsletters.
            emails = ['yachu.jeng@tracedig.com']
            text = json.load(open(os.path.join(os.path.dirname(__file__),
                                               'LargeMail.txt'), 'r'))
  
            data = urlencode({
                'token': token,
                'emails': ','.join(emails),
                'title': utf8((u'\u57fa\u91d1\u5e6b\u4f60\u8ffdo))  '
                               u'\u6de8\u503c\u901a\u77e5\u4fe1\u51fd')),
                'text': utf8(text),
                'group': utf8(u'\u6e2c\u8a66\u5e6b\u4f60\u8ffd_3')
            })
  
            conn = urlopen('%s/newsletters/api/app/mail/' % domain, data)
            result = json.loads(conn.read())
            results.append(result)
  
        with runTestServer(path=TARGET_PATH, port=7788, 
                           settings='Project.settings', 
                           fixtures=['initial_data'],
                           noInput=True, timeout=60):
            for x in range(1):
                print x + 1, ') ======='
                t = threading.Thread(target=_doSend, args=(SERVER_DOMAIN,))
                t.start()
            time.sleep(60)
  
            for r in results:
                self.assertTrue('id' in r)
                resultId = r['id']
                _d = urlencode({'id': resultId})
                _info = urlopen('%s/newsletters/api/newsletter/?id=%d' %
                                (SERVER_DOMAIN, resultId))
                _info = json.loads(_info.read())
                condition = (_info['status'] == 4) and (_info['id'] == resultId)
                self.assertTrue(condition)
  
    def _testMailer(self):
        """
        Test for send mail by multiple mails.
        
        The test will fail, the ticket of this testcase:
        https://code.nuwainfo.com/trac/mercurius/ticket/2751
        """
        results = []  
        def _doSend(data):
            conn = urlopen('%s/newsletters/api/app/mail/' % SERVER_DOMAIN, data)
            result = json.loads(conn.read())
            print result
            results.append(result)
  
        with runTestServer(path=TARGET_PATH, port=7788, 
                           settings='Project.settings', 
                           fixtures=['initial_data'],
                           noInput=True, timeout=60):            
                        
            # Login.
            loginData = urlencode({
                'user': 'admin', 'pwd': 'admin', 'app': 'Test mailer'})
            _re = urlopen('%s/newsletters/api/app/login/' %
                          SERVER_DOMAIN, loginData)
            _re = json.loads(_re.read())
            token = _re['token']
            self.assertTrue(token)
  
            emails = ['yachu.jeng@tracedig.com']
            text = u'<p><a href="#">dd</a></p>'
            data = urlencode({
                'token': token,
                'emails': ','.join(emails),
                'title': utf8(u'\u57fa\u91d1\u5e6b\u4f60\u8ffdo))  '
                              u'\u6de8\u503c\u901a\u77e5\u4fe1\u51fd'),
                'text': utf8(text),
                'group': utf8(u'\u6e2c\u8a66\u5e6b\u4f60\u8ffd_3'),
                'mode': 'async'
            })
                        
            for x in range(20):
                print x + 1, ') ======='
                t = threading.Thread(target=_doSend, args=(data,))
                t.start()
                print '\n'
            
            time.sleep(30)
            
            # Check results.
            for r in results:
                self.assertTrue('id' in r)
                resultId = r['id']
                _d = urlencode({'id': resultId})
                _info = urlopen('%s/newsletters/api/newsletter/?id=%d' %
                                (SERVER_DOMAIN, resultId))
                _info = json.loads(_info.read())
                print _info
                condition = (_info['status'] == 4) and (_info['id'] == resultId)
                self.assertTrue(condition)
                time.sleep(5)
  
    def testAttachment(self):
        """
        Test attachemnts.
        """
        results = []
        fileDetails = []
        def _doSend(data):
            conn = urlopen('%s/newsletters/api/app/mail/' % SERVER_DOMAIN, data)
            result = json.loads(conn.read())
            results.append(result)
  
        with runTestServer(path=TARGET_PATH, port=7788, 
                           settings='Project.settings', 
                           fixtures=['initial_data'],
                           noInput=True, timeout=60):
            
            urlopen('%s/' % SERVER_DOMAIN)
            # Login.
            loginData = urlencode({
                'user': 'admin', 'pwd': 'admin', 'app': 'Test mailer'})
            _re = urlopen('%s/newsletters/api/app/login/' %
                          SERVER_DOMAIN, loginData)
            _re = json.loads(_re.read())
            token = _re['token']
            self.assertTrue(token)
  
            emails = ['yachu.jeng@tracedig.com']
            text = u'<p><a href="#">dd</a></p>'
  
            data = {
                'token': token,
                'emails': ','.join(emails),
                'title': utf8(u'\u57fa\u91d1\u5e6b\u4f60\u8ffdo))  '
                              u'\u6de8\u503c\u901a\u77e5\u4fe1\u51fd'),
                'text': utf8(text),
                'group': utf8(u'\u6e2c\u8a66\u5e6b\u4f60\u8ffd_3'),
                'mode': 'sync',
            }
  
            fCount = 1;
            for p in os.listdir(os.path.join(
                os.path.dirname(__file__), 'attachments')):
                if os.path.splitext(p)[-1] == '.txt':
                    _p = os.path.join(
                        os.path.dirname(__file__), 'attachments', p)
                    _c = open(_p, 'rb').read()
                    data.update({
                        'attachmentName%d' % fCount: p,
                        'attachmentContent%d' % fCount: _c,
                    })
                    fileDetails.append((p, _c))
                    fCount += 1;
  
            _doSend(urlencode(data))
            # Check results.
            result = results[0]
            rId = result['id']
            _info = urlopen('%s/newsletters/api/newsletter/?id=%d' %
                            (SERVER_DOMAIN, rId))
            _info = json.loads(_info.read())
            print _info
            condition = (_info['status'] == 4) and (_info['id'] == rId)
            self.assertTrue(condition)
            _path = os.path.join(
                TARGET_PATH, 'Project', 'media',
                'uploads', 'newsletter', _info['slug'])
  
            for (name, content) in fileDetails:
                _p = os.path.join(_path, name)
                afterFile = open(_p, 'rb').read()
                self.assertEqual(content, afterFile)

if __name__ == "__main__":
    unittest.main()
