#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: admin.py 9948 2017-05-07 06:08:11Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-05-07 14:08:11 +0800 (�g��, 07 ���� 2017) $
# $Revision: 9948 $

from django.db import models
from django.conf import settings
from django.utils.translation import ugettext_lazy as _
from cms.models import CMSPlugin

from Zephyrus.comment import settings as _settings

class CommentPlugin(CMSPlugin):
    useFbComment = models.BooleanField(_('Use Facebook Comment'))

    renderTemplate = models.CharField(
        _('Comment Template'), max_length=150, blank=True,
        choices=_settings.ZEPHYRUS_COMMENT_TEMPLATES,
        default=_settings.ZEPHYRUS_COMMENT_DEFAULT_TEMPLATE,
    )

class Comment(models.Model):
    url = models.CharField(max_length=100, editable=False, null=True)
    
    user = models.ForeignKey(settings.AUTH_USER_MODEL, null=True, blank=True)
    email = models.EmailField(max_length=254, null=True, blank=True)

    message = models.TextField()

