#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: views.py 11167 2018-07-14 21:21:46Z Lavender $
#
# Copyright (c) 2018 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License, 
# you may not use this file except in compliance with the License. 
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and 
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2018-07-15 06:21:46 +0900 (週日, 15 七月 2018) $
# $Revision: 11167 $ 

import json
import logging

from django.views.decorators.csrf import csrf_exempt
from django.utils.decorators import method_decorator
from django.shortcuts import redirect
from django.contrib import messages
from paypal.express.views import SuccessResponseView
from oscar.core.loading import get_model, get_class

from Iuno.shop import forms
from Iuno.shop.models import ECPayTrade, AllPayTrade

PaymentDetailsView = get_class('checkout.views', 'PaymentDetailsView')

Source = get_model('payment', 'Source')
SourceType = get_model('payment', 'SourceType')
Basket = get_model('basket', 'Basket')

logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)
logger.addHandler(logging.StreamHandler())

SPGATEWAY = 'spgateway'
ALLPAY = 'allpay'
ECPAY = 'ecpay'
    
class SuccessResponseView(SuccessResponseView):
    def get_shipping_address(self, basket):
        return PaymentDetailsView.get_shipping_address(self, basket)

class SuccessResponseView2(PaymentDetailsView):
    preview = True
    
    @method_decorator(csrf_exempt)
    def dispatch(self, request, *args, **kwargs):
        return super(SuccessResponseView2, self).dispatch(request, 
                                                         *args, **kwargs)
    
    def post(self, request, *args, **kwargs):
        # apiName
        self.apiName = kwargs['name']

        if not self.apiName in [SPGATEWAY, ALLPAY, ECPAY]:
            raise ValueError("Not pay api name: %s" % apiName)

        if self.apiName in [ALLPAY, ECPAY]:
            # data
            self.tradeNo = request.POST.get('TradeNo')
            self.tradeAmt = request.POST.get('TradeAmt')
            self.merchantID = request.POST.get('MerchantID')
            self.merchantTradeNo = request.POST.get('MerchantTradeNo')
            self.rtnCode = request.POST.get('RtnCode')
            self.rtnMsg = request.POST.get('RtnMsg')
            self.payAmt = request.POST.get('MerchantID')
            self.tradeDate = request.POST.get('TradeDate')
            self.paymentType = request.POST.get('PaymentType')
            self.simulatePaid = request.POST.get('SimulatePaid')
            self.paymentDate = request.POST.get('PaymentDate')
            self.paymentTypeChargeFee = request.POST.get('PaymentTypeChargeFee')

            # basket
            index = request.POST.get('MerchantTradeNo').find('BASKETID')
            self.basketId = int(request.POST.get('MerchantTradeNo')[index + 8:])

            # error
            if self.rtnMsg == 'ERROR':
                messages.warning(self.request, 'PAY API ERROR!!')
                logger.error('ERROR !!')
                return redirect('checkout:shipping-address')
        
            # record trade data
            """
            ecpayTrade = ECPayTrade.objects.create(
                tradeNo=self.tradeNo,
                tradeAmt=int(self.tradeAmt),
                merchantId=self.merchantID,
                merchantTradeNo=self.merchantTradeNo,
                rtnCode=self.rtnCode,
                payAmt=int(self.payAmt),
                tradeDate=self.tradeDate.replace('/', '-'),
                paymentType=self.paymentType,
                simulatePaid=self.simulatePaid,
                paymentDate=self.paymentDate.replace('/', '-'),
                paymentTypeChargeFee=self.paymentTypeChargeFee
            )
            ecpayTrade.save()
            """
        else:
            # data
            data = json.loads(request.POST.get('JSONData', '{}'))
       
            self.status = data.get('Status')
            self.message = data.get('Message')
            self.result = json.loads(data.get('Result', '{}'))
            self.tradeNo = self.result.get("TradeNo")
            self.tradeAmt = self.result.get("Amt")
            
            # basket
            index = self.result.get('MerchantOrderNo').find('BASKETID')
            self.basketId = int(self.result.get('MerchantOrderNo')[index + 8:])

            # error
            if not self.status == 'SUCCESS':
                messages.warning(self.request, 'PAY API ERROR!!')
                logger.error('ERROR !!')
                return redirect('checkout:shipping-address')

            # record trade data
        
        if not self.preview:
            return http.HttpResponseBadRequest()
        return self.handle_place_order_submission(request)
        
        
    def build_submission(self, **kwargs):
        submission = super(
            SuccessResponseView2, self).build_submission(**kwargs)
        
        
        submission['payment_kwargs']['tradeNo'] = self.tradeNo
        submission['payment_kwargs']['tradeAmt'] = self.tradeAmt
        submission['payment_kwargs']['basketId'] = self.basketId
        return submission

    
    def handle_payment(self, order_number, total, **kwargs):
        tradeAmt = int(kwargs['tradeAmt'])
        tradeNo = kwargs['tradeNo']
        source_type, is_created = SourceType.objects.get_or_create(
            name=self.apiName)
        source = Source(source_type=source_type,
                        currency='TWD',
                        amount_allocated=tradeAmt,
                        amount_debited=tradeAmt) 
        
        self.add_payment_source(source)
        self.add_payment_event('Settled', tradeAmt,
                               reference=tradeNo)
        
    


