#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: views.py 10850 2018-03-17 23:41:09Z David $
#
# Copyright (c) 2013 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: David $
# $Date: 2013-01-30 12:13:45 +0800$
# $Revision: 10850 $

from django.shortcuts import render_to_response, get_object_or_404
from django.utils.translation import ugettext_lazy as _
from django.views.decorators.csrf import csrf_exempt
from django.template import Template
from django.template.loader import render_to_string
from django.core.urlresolvers import reverse
from django.shortcuts import redirect
from django.conf import settings
from django.contrib.admin.views.decorators import staff_member_required
from django.template import RequestContext
from django.contrib.auth.decorators import login_required


from Iuppiter.extension.views import jsonpCallback

from emencia.django.newsletter.models import Newsletter, MailingList, \
                                             ContactMailingStatus, Contact

from Theophrastus.newsletter_extension.models import Header, Footer
from Theophrastus.Utility import _slugify

@staff_member_required
@jsonpCallback(noPadding=True)
def getDefaultHeaderText(request):
    c = render_to_string('NewsletterDefaultHeader.html')
    return {'content': unicode(c)}

@staff_member_required
@jsonpCallback(noPadding=True)
def getDefaultFooterText(request):

    c = render_to_string('NewsletterDefaultFooter.html')
    return {'content': unicode(c)}

@csrf_exempt
@jsonpCallback(noPadding=True)
def getNewsletterInfo(request):
    try:
        newsletterId = request.GET.get('id', None)
        if newsletterId is None:
            raise RuntimeError('Invalid id.')
        else:
            newsletterId = int(newsletterId)
            newsletter = Newsletter.objects.get(id=newsletterId)
            formatStr = '%Y-%m-%d %H:%M:%S'
            return {
                'id': newsletter.id,
                'status': newsletter.status,
                'sendingDate': newsletter.sending_date.strftime(formatStr),
                'slug': newsletter.slug
            }
    except Exception as e:
        return {'error': str(e)}

# Theophrastus/static/js/Newsletter.js
# Theophrastus/templates/admin/newsletter/newsletter/change_form.html
@jsonpCallback(noPadding=True)
def getSlugName(request):
    """
    Get slug name.

    @param request Request instance.
    """
    title = request.GET.get('title', '')
    if title:
        return {'slug': _slugify(title)}
    else:
        return {}

# Theophrastus/static/js/Newsletter.js
# Theophrastus/templates/admin/newsletter/newsletter/change_form.html
@jsonpCallback()
def getMailingListInfo(request):
    """
    Get MailingList information.

    @param request Request instance.
    """
    mailingListId = request.GET.get('mailingList', '')
    newsletterIds = request.GET.get('newsletters', '')
    newsletterIds = newsletterIds.split('_')
    try:
        if mailingListId:
            mailingList = MailingList.objects.get(id=mailingListId)
            return {
                'subscribersCount': mailingList.subscribers_count(),
                'name': mailingList.name
            }
        elif newsletterIds:
            info = []
            for n in Newsletter.objects.filter(id__in=newsletterIds):
                mailingList = n.mailing_list
                info.append({
                    'subscribersCount': mailingList.subscribers_count(),
                    'name': n.title
                })

            return {'info': info}
    except Exception as e:
        pass
    return {'error': str(e)}

def _replaceContent(content):
        """
        Replace content of http/https of an email link in header/footer.

        @param content The content of replaced.
        """

        if (hasattr(settings, 'SECURE_PROXY_SSL_HEADER') and
            settings.SECURE_PROXY_SSL_HEADER):
            protocol = 'https'
        else:
            protocol = 'http'

        mapping = (
            ("http://NEWSLETTER_SITE_LINK",
             ("%s://{{ domain }}{%% url 'newsletter_newsletter_contact' " % (
                 protocol, ) +
             "slug=newsletter.slug uidb36=uidb36 token=token %}")),
            ("http://NEWSLETTER_UNSUBSCRIBE_LINK",
             ("{%% if uidb36 and token %%}%s://{{ domain }}" % (protocol, ) +
             "{% url 'newsletter_mailinglist_unsubscribe' "
             "slug=newsletter.slug uidb36=uidb36 token=token %}"
             "{% else %}#{% endif %}")),
        )

        for (key, _c) in mapping:
            content = content.replace(key, _c)
        return content

def getHeaderContent(newsletter):
        """
        Get content of newsletter's header.
        """
        try:
            header = newsletter.header
            if not header:
                header = Header.objects.all()[0]
            _content = _replaceContent(header.content)
            return Template(_content)
        except:
            return None

def getFooterContent(newsletter):
    """
    Get content of newsletter's footer.
    """
    try:
        footer = newsletter.footer
        if not footer:
            footer = Footer.objects.all()[0]
        _content = _replaceContent(footer.content)
        return Template(_content)
    except:
        return None
