#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: models.py 11616 2019-06-07 02:15:46Z Andy $
#
# Copyright (c) 2012 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Andy $
# $Date: 2019-06-07 10:15:46 +0800 (週五, 07 六月 2019) $
# $Revision: 11616 $

from django.utils.translation import ugettext as _

from emencia.django.newsletter import models as emModels

import types

from django.db import models

@models.permalink
def getStatisticsUrl(self):
    return ('Theophrastus.views.displayStatistics', (self.slug,))

@models.permalink
def getSubscriberUrl(self):
    return ('Theophrastus.views.displaySubscribers', (self.slug,))

# emModels.Newsletter.getStatisticsUrl = types.MethodType(
#     getStatisticsUrl, None, emModels.Newsletter)
emModels.Newsletter.getStatisticsUrl = getStatisticsUrl

# emModels.Newsletter.getSubscriberUrl = types.MethodType(
    # getSubscriberUrl, None, emModels.Newsletter)
emModels.Newsletter.getSubscriberUrl = getSubscriberUrl

def getUnicode(self):
    if self.id == 1:
        return _("Cloud SMTP Server")
    return '%s (%s)' % (self.name, self.host)

# emModels.SMTPServer.__unicode__ = types.MethodType(
    # getUnicode, None, emModels.SMTPServer)

emModels.SMTPServer.__unicode__ = getUnicode
