#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: __init__.py 11859 2020-01-12 11:48:41Z Lavender $
#
# Copyright (c) 2019 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $ (last)
# $Date: 2020-01-12 19:48:41 +0800 (Sun, 12 Jan 2020) $
# $Revision: 11859 $
#
# Contributors:
#  Bear (original author)
#  Yachu

from Iuno.Util import update

from Iuppiter.DjangoUtil import (
    extendInstalledApps, extendMiddlewareClasses)

def attachSettings(settingsLocals, backends, preferred, config):
    """
    Attach 'mail' related settings to settings.py.

    @param settingsLocals locals() in settings.py.
    @param backends Backend instances.
    @param preferred Preferred backends.
    @param config Configuration settings.
    """
    extendInstalledApps(settingsLocals, (
        'django_statsd',
        'Iuno.cloud.metrics',
    ))
    
    # https://code.nuwainfo.com/trac/Mercurius/ticket/3302#ticket
    # 先註解移掉
    # extendMiddlewareClasses(
        # settingsLocals, 
        # [
            # 'django_statsd.middleware.StatsdMiddleware',
        # ], 
        # key='django.contrib.sessions.middleware.SessionMiddleware', 
        # addBefore=True
    # )
    
    # extendMiddlewareClasses(settingsLocals, [
        # 'django_statsd.middleware.StatsdMiddlewareTimer',
    # ])
    
    DEFAULT_STATSD_SETTINGS = {
        'STATSD_HOST': config.get("host", "statsd.nuwainfo.com"),
        "STATSD_PORT": config.get("post", 8125),
    }
    
    update(settingsLocals, DEFAULT_STATSD_SETTINGS)

