#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: export_articles.py 12561 2020-10-17 11:42:28Z Becca $
#
# Copyright (c) 2020 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Becca $
# $Date: 2020-10-17 19:42:28 +0800 (Sat, 17 Oct 2020) $
# $Revision: 12561 $

import json
import os
import shutil

from django.core.management.base import BaseCommand
from django.core.management import call_command
from django.utils.translation import activate
from django.db import connection, models
from django.conf import settings
from django.contrib.staticfiles import finders

from Iuppiter.Util import archiveZip

class Command(BaseCommand):
    help = "add the arguments(language, domain name)"
    def add_arguments(self, parser):
        parser.add_argument('--language', type=str, default='zh_hant', help="default is 'zh_hant'")
        parser.add_argument(
            '--domainName', type=str, default="", help="default is empty, and will get the URL in settings"
        )

    def handle(self, *args, **options):

        domainName = options['domainName']
        language = options['language']
        activate(language)

        import pandas as pd

        from aldryn_newsblog.models import Article
        from aldryn_categories.models import Category
        from filer.models import File, Image
        from taggit.models import Tag, TaggedItemBase, ItemBase
        from aldryn_newsblog.utils import get_plugin_index_data, get_request, strip_tags
        from aldryn_newsblog.tests.test_cms_wizards import CreateNewsBlogArticleFormTestCase
        from cms.utils.conf import get_cms_setting

        # create a folder for articles
        os.makedirs('ArticlesAndImages')
        os.makedirs('ArticlesAndImages/Articles')
        os.makedirs('ArticlesAndImages/Articles/FeaturedImages') # featured_image

        # export db table as dataframe
        translation = pd.read_sql("SELECT * FROM aldryn_newsblog_article_translation", con=connection)
        article = pd.read_sql("SELECT * FROM aldryn_newsblog_article", con=connection)
        cmsPlugin = pd.read_sql("SELECT * FROM cms_cmsplugin", con=connection)
        cmsPlaceholder = pd.read_sql("SELECT * FROM cms_placeholder", con=connection)
        textCkeditorText = pd.read_sql("SELECT * FROM djangocms_text_ckeditor_text", con=connection)


        textPluginPalceholder = cmsPlaceholder.merge(cmsPlugin, how="inner")
        cmsPlugin = cmsPlugin.sort_values('placeholder_id')
        cmsPlugin.rename(columns={'id': 'cmsplugin_ptr_id'}, inplace=True)
        # merge textCkeditorText and cmsPlugin on cmsplugin_ptr_id
        textPlugin = textCkeditorText.join(cmsPlugin.set_index('cmsplugin_ptr_id'), on='cmsplugin_ptr_id')
        cmsPlaceholder.rename(columns={'id': 'placeholder_id'}, inplace=True)
        # merge plugin and placeholder on placeholder_id
        textPluginPlaceholder = textPlugin.merge(cmsPlaceholder, on='placeholder_id')
        # filter textPluginPlaceholder['slot'] == 'newsblog_article_content'
        textPluginPlaceholder[textPluginPlaceholder['slot'] == 'newsblog_article_content']
        pluginPlaceholder = cmsPlaceholder.join(cmsPlugin.set_index('placeholder_id'), on='placeholder_id')
        # merge article and articleTranslation on master_id
        articleTranslation = article.merge(translation, left_on='id', right_on='master_id')
        articleTranslation.rename(columns={'content_id': 'placeholder_id'}, inplace=True)
        # merge textPluginPlaceholder and articleTranslation on placeholder_id
        allArticles = pd.merge(textPluginPlaceholder, articleTranslation, on=['placeholder_id'])
        allArticles.sort_values('master_id')


        taggitTag = pd.read_sql("SELECT * FROM taggit_tag", con=connection)
        taggitTaggedItem = pd.read_sql("SELECT * FROM taggit_taggeditem", con=connection)
        tags = taggitTag.merge(taggitTaggedItem, left_on='id', right_on='tag_id')

        allArticles['tags'] = ''
        for i in range(len(allArticles)):
            objectId = allArticles.loc[i, 'master_id']
            tagList = list(tags[tags['object_id'] == objectId]['name'])
            tagListString = ' '.join(tagList)
            allArticles.loc[i, 'tags'] = tagListString

        articles = Article.objects.all()
        for index, article in enumerate(articles):
            categories = article.categories
            articleName = f'第{index + 1}篇'
            articleDict = {}
            articleDict['title'] = str(article)
            articleDict['categories'] = []
            articleURL = article.get_absolute_url()
            statisticsURL = pd.read_sql("SELECT * FROM statistics_url", con=connection)
            if domainName:
                pass
            else:
                domainName = f"https://www.{settings.IUNO_SITE_DOMAIN_NAMES[3]}" # ['PRODUCTION']
            articleURLInDB = statisticsURL[statisticsURL['url'] == f"{domainName}{articleURL}"]
            if articleURLInDB.empty:
                pass
            else:
                articleDict['viewCount'] = int(articleURLInDB["viewCount"].values[0])
                articleDict['likeCount'] = int(articleURLInDB["likeCount"].values[0])
                articleDict['commentCount'] = int(articleURLInDB["commentCount"].values[0])

            if article.categories.all():
                for c in article.categories.all():
                    articleDict['categories'].append(c.name)

            description = article.safe_translation_getter('lead_in', '')

            description = [strip_tags(description)]
            articleDict['description'] = description

            if article.content:
                plugins = article.content.cmsplugin_set.filter(language=language)
                for base_plugin in plugins:
                    plugin_text_content = ' '.join(
                        get_plugin_index_data(base_plugin, get_request(language=language)))
                    description.append(plugin_text_content)
                    articleDict['content'] = ' '.join(description)

            articleSlug = article.safe_translation_getter('slug', any_language=True)
            featuredImageId = None
            featuredImagePath = None
            featuredImageId = article.featured_image_id
            if featuredImageId != None:
                featuredImage = File.objects.get(id=featuredImageId)
                featuredImagePath = str(featuredImage.file)
                shutil.copy(f'{settings.MEDIA_ROOT}/{featuredImagePath}',
                            f"ArticlesAndImages/Articles/FeaturedImages/{articleSlug}.png")


            articleDict['slug'] = articleSlug
            articleDict['author'] = str(article.author)
            articleDict['publishing_date'] = str(article.publishing_date)
            tagList = allArticles[allArticles['title'] == str(article)]['tags'].values[0].split(' ')
            articleDict['tags'] = tagList
            metaTitle = article.safe_translation_getter('meta_title', any_language=True)
            metaDescription = article.safe_translation_getter('meta_description', any_language=True)
            metaKeywords = article.safe_translation_getter('meta_keywords', any_language=True)
            searchData = article.safe_translation_getter('search_data', any_language=True)
            articleDict['metaTitle'] = metaTitle
            articleDict['metaKeywords'] = metaKeywords
            articleDict['metaDescription'] = metaDescription
            articleDict['searchData'] = searchData
            articleDict['body'] = allArticles[allArticles['title'] == str(article)]['body'].values[-1]
            articleDict['featuredImageId'] = featuredImageId
            articleDict['featuredImagePath'] = featuredImagePath
            with open(f"ArticlesAndImages/Articles/{articleName}.json", "w") as outfile:
                json.dump(articleDict, outfile, ensure_ascii=False)



        # get images
        # create a folder for images path
        os.makedirs('ArticlesAndImages/Images')
        os.makedirs('ArticlesAndImages/Images/images')

        sql = f"SELECT * FROM aldryn_newsblog_article, aldryn_newsblog_article_translation, cms_placeholder, \
                            cms_cmsplugin, cmsplugin_filer_image_filerimage \
                         WHERE  aldryn_newsblog_article.id = aldryn_newsblog_article_translation.master_id and \
                                aldryn_newsblog_article.content_id = cms_cmsplugin.placeholder_id  and \
                                cms_placeholder.id = cms_cmsplugin.placeholder_id and \
                                cms_placeholder.slot = 'newsblog_article_content' and \
                                cmsplugin_filer_image_filerimage.cmsplugin_ptr_id = cms_cmsplugin.id"

        cmsPlaceholderImageDF = pd.read_sql(sql, con=connection)

        filerImageSQL = f"SELECT * FROM filer_image"
        filerImage = pd.read_sql(filerImageSQL, con=connection)

        filerFileSQL = f"SELECT * FROM filer_file"
        filerFile = pd.read_sql(filerFileSQL, con=connection)

        imagePlugin = cmsPlaceholderImageDF.merge(filerImage, left_on='image_id', right_on='file_ptr_id')
        result = imagePlugin.merge(filerFile, left_on='file_ptr_id', right_on='id')

        uniqueArticleSlug = result.slug.unique()

        for index, slugName in enumerate(uniqueArticleSlug):
            articleSlugName = f'{slugName}'
            imageDict = {}
            imageDict['slug'] = articleSlugName
            imageDict['file'] = []
            imageDict['oringinalName'] = []
            imageDict['imageName'] = []
            imageDict['imageHeight'] = []
            imageDict['imageWidth'] = []
            imageIndex = 1
            filePath = None
            for j in range(len(result)):
                file = result.loc[j, 'image_url']
                filePath = finders.find(file)
                if file == '' or file == None:
                    file = result.loc[j, 'file']
                    filePath = f'{settings.MEDIA_ROOT}/{file}'
                oringinalName = result.loc[j, 'original_filename']
                imageUrl = result.loc[j, 'image_url']
                height = result.loc[j, '_height']
                width = result.loc[j, '_width']

                if result.loc[j, 'slug'] == str(articleSlugName):
                    imageName = f'{articleSlugName}_{imageIndex}'
                    if imageUrl:
                        absolutePath = finders.find(imageUrl)
                        imageDict['file'].append(absolutePath)
                    else:
                        imageDict['file'].append(file)
                        imageDict['oringinalName'].append(oringinalName)

                    imageDict['imageName'].append(f'{imageName}.png')
                    imageDict['imageHeight'].append(f'{height}px')
                    imageDict['imageWidth'].append(f'{width}px')
                    imageIndex += 1
                shutil.copy(f'{filePath}', f"ArticlesAndImages/Images/images/{imageName}.png")

            with open(f"ArticlesAndImages/Images/{articleSlugName}.json", "w") as outfile:
                json.dump(imageDict, outfile, ensure_ascii=False)

        if settings.APP_NAME:
            archiveZip('ArticlesAndImages',f'{settings.APP_NAME}_ArticlesAndImages.zip')
        else:
            archiveZip('ArticlesAndImages','ArticlesAndImages.zip')
        shutil.rmtree('ArticlesAndImages')
