#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: import_articles.py 12563 2020-10-17 16:32:09Z Becca $
#
# Copyright (c) 2020 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Becca $
# $Date: 2020-10-18 00:32:09 +0800 (Sun, 18 Oct 2020) $
# $Revision: 12563 $

import os
import re

from django.core.management.base import BaseCommand
from django.core.management import call_command
from django.utils.translation import activate
from django.conf import settings
from django.db import models

from cms.test_utils.project.extensionapp.models import MyPageExtension

from Iuppiter.Util import extractZip
from Zephyrus.statistics.models import URL

import sys
import argparse
from Zephyrus.statistics.templatetags.StatisticsTags import viewCount

class Command(BaseCommand):
    help = 'add the arguments(path, language, namespace, imgClass)'
    def add_arguments(self, parser):
#         parser.add_argument('pathLanguageNamespaceImgClass', nargs='+', type=str)
        parser.add_argument('--path', help="must give article apth.")
        parser.add_argument('--language', default='zh_hant', help="default is 'zh_hant'.")
        parser.add_argument(
            '--namespace',
            default='',
            help="default is empty, and then will get the last app hook config namespace in NewsBlogConfig"
        )
        parser.add_argument('--imgClass', default='', help="input the template img tag")
        parser.add_argument('--domainName', default='', help="default is empty, and will get the URL in settings")

    def handle(self, *args, **options):
        import json
        import shutil
        from os.path import isfile, isdir, join
        from distutils.dir_util import copy_tree

        from django.utils.timezone import now
        from datetime import datetime
        from aldryn_newsblog.models import Article, NewsBlogConfig
        from filer.models import File, Image
        from aldryn_apphooks_config.models import AppHookConfig
        from aldryn_people.models import Person
        from django.contrib.auth.models import User
        from aldryn_newsblog.tests.test_commands import TestCommands
        from cms import api

        articlesAndImages = extractZip(options['path'], 'ArticlesAndImages')

        articlesPath = None
        ImagesJson = None
        Images = None
        staticImages = None
        for root, dirs, files in os.walk('ArticlesAndImages'):
            if "Articles" in dirs:
                articlesPath = f'{root}/Articles'
                print('articlesPath', articlesPath)
            if "Images" in dirs:
                ImagesJson = f'{root}/Images'
                print('ImagesJson', ImagesJson)
            if "images" in dirs:
                Images = f'{root}/images'
                staticImages = f'{settings.STATIC_ROOT}/images'
                copy_tree(Images, staticImages)
            if "FeaturedImages" in dirs:
                featureImages = f'{root}/FeaturedImages'
                filerImages = f'{settings.MEDIA_ROOT}/filer_public/FeaturedImages'
                copy_tree(featureImages, filerImages)


        language = options['language']
        activate(language)

        namespace = options['namespace']
        if namespace:
            pass
        else:
            namespace = str(NewsBlogConfig.objects.last())

        class _TestCommands(TestCommands):

            def create_article(self, content=None, **kwargs):
                self.app_config = NewsBlogConfig.objects.language(language).get(
                    namespace=namespace,
                )
#                 author = Person.objects.get(translations__name=kwargs['author'])
                try:
                    author = Person.objects.get(translations__name=kwargs['author'])
#                 since does not get author
                except:
                    userExist = User.objects.filter(username=kwargs['author']).exists()
                    if userExist:
                        authorUser = User.objects.get(username=kwargs['author'])
                    else:
                        authorUser = User.objects.create(username=kwargs['author'])
                    # have to create the author
                    Person.objects.create(user=authorUser, name=kwargs['author'])
                    author = Person.objects.get(user=authorUser)

                user = User.objects.get(id=1)

                fields = {
                    'title': kwargs['title'],
                    'slug': kwargs['slug'],
                    'author': author,
                    'owner': user,
                    'app_config': self.app_config,
                    'publishing_date': kwargs['publishingTime'],
                    'is_published': True,
                }

                article = Article.objects.create(**fields)
                article.save()

                if content:
                    api.add_plugin(article.content, 'TextPlugin',
                                   'zh-hant', body=content)
                return article

        testCommands = _TestCommands()

        articlesNum = len(os.listdir(articlesPath))
        imgClass = options['imgClass']
         # articlesNum includes Featured Images folder, so have to minus 1. 第{i+1}篇, have to minus 1 again. -> minus 2
        for i in range(articlesNum - 2):
            with open(f'{articlesPath}/第{i+1}篇.json') as articleJsonFile:
                data = json.load(articleJsonFile)
            data['publishing_date'] = datetime.strptime(data['publishing_date'].split('+')[0], '%Y-%m-%d %X')
            tags = data['tags']
            content = data['body']
            try:
                with open(f'{ImagesJson}/{data["slug"]}.json') as imageNameJsonFile:
                    dataImg = json.load(imageNameJsonFile)
                    imageNames = dataImg['imageName']
                    height = dataImg['imageHeight']
                    width = dataImg['imageWidth']
                    for index, imageName in enumerate(imageNames):
                        cmsPlugin = re.findall('<cms-plugin .*></cms-plugin>', content)
                        print(cmsPlugin)
                        content = content.replace(
                            cmsPlugin[0],
                            f'<img class=f"{imgClass}" height="{height[index]}" width = "{height[index]}" \
                            src="{settings.STATIC_URL}/images/{imageName}" alt="">')
            except:
                print('article has no images', )
            img = Image.objects.create()
            img.save()
            filerFile = File.objects.filter(id=img.file_ptr_id)
            filerFile.update(file=f"filer_public/FeaturedImages/{data['slug']}.png")
            try:
                articleCreate = testCommands.create_article(
                        content=content,
                        title=data['title'],
                        slug=data['slug'],
                        author=data['author'],
                        publishingTime = data['publishing_date'],
                        lead_in = data['description'],
                )
                articles = {}
    #                     articleCreate.save()
                metaDescription = data['metaDescription']
                if (metaDescription.strip() == 'nan') or (metaDescription == None):
                    metaDescription = " "
                articleCreate.meta_description = metaDescription
                articleCreate.save()
                Article.objects.filter(id=articleCreate.id).update(featured_image_id=filerFile[0].id)

                tagged_articles = []
                for tag in tags:
                    if tag.strip() == None or tag.strip() == "":
                        pass
                    else:
                        articleCreate.tags.add(tag)
                tagged_articles.append(articleCreate)
                tag_slug = tagged_articles[0].tags.slugs()
                articles[tag_slug] = tagged_articles
            except:
                print(f'Article {i+1} has some problem')

            if "viewCount" in data.keys():
                url = ""
                domainName = options['domainName']
                if domainName:
                    pass
                else:
                    domainName = f"https://www.{settings.IUNO_SITE_DOMAIN_NAMES[3]}" # ['PRODUCTION']
                url=f"{domainName}{articleCreate.get_absolute_url()}"
                try:
                    obj = URL.objects.get(url=url)
                    obj.viewCount = data['viewCount']
                except URL.DoesNotExist:
                    obj = URL.objects.create(url=url,viewCount=data['viewCount'])
                    obj.save()
                obj.save()

        shutil.rmtree('ArticlesAndImages')



