#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: models.py 12487 2020-08-27 11:21:50Z Casey $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Casey $
# $Date: 2020-08-27 19:21:50 +0800 (Thu, 27 Aug 2020) $
# $Revision: 12487 $

from django.db import models
from django.utils.translation import ugettext_lazy as _

class AdminPlaceholder(models.Model):
    name = models.CharField(_("Name"), max_length=120, editable=False, null=True)
    fromUrl = models.CharField(max_length=400, editable=False, null=True)
    page = models.ForeignKey(
        'cms.Page',
        on_delete=models.CASCADE,
        editable=False,
        default=None,
        null=True,
    )
    text = models.TextField(_("Text"))
    useGlobalAdminPlaceholder = models.BooleanField(
        _("Use Global AdminPlaceholder Value"), default=False)
        
    def __unicode__(self):
        return u"AdminPlaceholder: %d" % (self.id,)

    class Meta:
        verbose_name = _('AdminPlaceholder')
        verbose_name_plural = _('AdminPlaceholder')
        
        
class BlockDisplayControl(models.Model):
    name = models.CharField(_("Name"), max_length=120, editable=False, null=True)
    fromUrl = models.CharField(max_length=400, editable=False, null=True)
    page = models.ForeignKey(
        'cms.Page',
        on_delete=models.CASCADE,
        editable=False,
        default=None,
        null=True
    )
    display = models.BooleanField(_("Display"), default=True)
    useGlobalBlockDisplayControl = models.BooleanField(
        _("Use Global BlockDisplayControl Value"), default=False)
        
    def __unicode__(self):
        return u"BlockDisplayControl: %d" % (self.id,)

    class Meta:
        verbose_name = _('BlockDisplayControl')
        verbose_name_plural = _('BlockDisplayControl')
