#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: __init__.py 11517 2019-05-03 12:53:40Z Andy $
#
# Copyright (c) 2019 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Andy $ (last)
# $Date: 2019-05-03 21:53:40 +0900 (週五, 03 五月 2019) $
# $Revision: 11517 $
#
# Contributors:
#  Bear (original author)
#  Yachu

from Iuppiter.DjangoUtil import (
    extendInstalledApps, extendMiddlewareClasses)

def attachSettings(settingsLocals, backends, preferred, config):
    """
    Attach 'mail' related settings to settings.py.

    @param settingsLocals locals() in settings.py.
    @param backends Backend instances.
    @param preferred Preferred backends.
    @param config Configuration settings.
    """
    extendInstalledApps(settingsLocals, (
        'django_statsd',
    ))
    
    extendMiddlewareClasses(settingsLocals, [
        'django_statsd.middleware.StatsdMiddleware',
        ], 
        key='django.contrib.sessions.middleware.SessionMiddleware', 
        addBefore=True
    )
    
    extendMiddlewareClasses(settingsLocals, [
        'django_statsd.middleware.StatsdMiddlewareTimer',
    ])

