#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: views.py 11635 2019-06-12 07:29:45Z Lavender $
#
# Copyright (c) 2018 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License, 
# you may not use this file except in compliance with the License. 
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and 
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2019-06-12 16:29:45 +0900 (週三, 12 六月 2019) $
# $Revision: 11635 $ 

import json
import logging
import hashlib
import base64
import urllib
import six

from collections import OrderedDict

import requests

from lxml import etree
from django.shortcuts import render
from django.contrib.sites.shortcuts import get_current_site
from django.views.decorators.csrf import csrf_exempt
from django.utils.decorators import method_decorator
from django.shortcuts import redirect, get_object_or_404
from django.core.urlresolvers import reverse
from django.contrib import messages
from django.views import generic
from django.utils.translation import ugettext as _
from django.conf import settings
from django.http import HttpResponse, Http404, HttpResponseRedirect
from django.utils import timezone
from django.template.loader import get_template
from django.template import Context
from django.db.models import Q
from paypal.express.views import SuccessResponseView
from oscar.core.loading import get_model, get_class
from phonenumber_field.phonenumber import to_python
from oscar.core.compat import get_user_model

from Iuppiter.Encoding import utf8
from Iuppiter.Encryption import Encryptor
from Iuppiter.DjangoUtil import DJANGO_VERSION
from Iuno.shop import forms
from Iuno.shop import buildAPIForm
from Iuno.shop.models import (
    ECPayTrade, AllPayTrade, SpgatewayTrade, CathaybkCreditTrade,
    ECPayLogisticTrade)
from Iuno.shop.Util import createCheckValue

_PaymentDetailsView = get_class('checkout.views', 'PaymentDetailsView')

Source = get_model('payment', 'Source')
SourceType = get_model('payment', 'SourceType')
Basket = get_model('basket', 'Basket')
Order = get_model('order', 'Order')
Selector = get_class('partner.strategy', 'Selector')
try:
    Applicator = get_class('offer.applicator', 'Applicator')
except ModuleNotFoundError:
    # fallback for django-oscar<=1.1
    Applicator = get_class('offer.utils', 'Applicator')

logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)
logger.addHandler(logging.StreamHandler())

fileHandler = logging.FileHandler('Payment.log')
fileHandler.setLevel(logging.WARNING)
logger.addHandler(fileHandler)

DEVELOPMENT = 1

SPGATEWAY = 'spgateway'
ALLPAY = 'allpay'
ECPAY = 'ecpay'
ECPAY_LOGISTIC = 'ecpay_logistic'
ECPAY_MAP = 'ecpay_map'

CATHAYBK_CREDIT = 'cathaybk-credit' # /cathaybk-credit/checkxml/
CATHAYBK_CUP = 'cathaybk-cup' # /cathaybk-cup/checkxml/
    
class SuccessResponseView(SuccessResponseView):
    def get_shipping_address(self, basket):
        return _PaymentDetailsView.get_shipping_address(self, basket)

# patch
from oscar.apps.checkout import views
from oscar.apps.dashboard.orders.views import OrderListView
from oscar.core.compat import UnicodeCSVWriter

if DJANGO_VERSION >= 10900: # django >= 1.9.0
    from collections import OrderedDict as SortedDict
else:
    from django.utils.datastructures import SortedDict
from oscar.core.utils import format_datetime

def get_context_data(self, **kwargs):
    kwargs = super(views.PaymentDetailsView, self).get_context_data(**kwargs)
    
    submission = self.build_submission()

    ecpayEnable = False
    if hasattr(settings, 'IUNO_SHOP_ECPAY_ENABLE'):
        ecpayEnable = settings.IUNO_SHOP_ECPAY_ENABLE

    allpayEnable = False
    if hasattr(settings, 'IUNO_SHOP_ALLPAY_ENABLE'):
        allpayEnable = settings.IUNO_SHOP_ALLPAY_ENABLE

    spgatewayEnable = False
    if hasattr(settings, 'IUNO_SHOP_SPGATEWAY_ENABLE'):
        spgatewayEnable = settings.IUNO_SHOP_SPGATEWAY_ENABLE

    cathaybkEnable = False
    if hasattr(settings, 'IUNO_SHOP_CATHAYBK_ENABLE'):
        cathaybkEnable = settings.IUNO_SHOP_CATHAYBK_ENABLE
    
    if ecpayEnable:
        kwargs['ecpay'] = buildAPIForm(submission, self.request, 'ecpay')
        kwargs['ecpay_map'] = \
            buildAPIForm(submission, self.request, 'ecpay_map')
        kwargs['ecpay_logistic'] = \
            buildAPIForm(submission, self.request, 'ecpay_logistic')
    if allpayEnable:
        kwargs['allpay'] = buildAPIForm(submission, self.request, 'allpay')
    if spgatewayEnable:
        kwargs['spgateway'] = buildAPIForm(
                                        submission, self.request, 'spgateway')
    if cathaybkEnable:
        kwargs['cathaybk'] = buildAPIForm(
                                        submission, self.request, 'cathaybk')

    if self.request.session.get('logisticMap'):
        mapData = json.loads(self.request.session['logisticMap'])
        kwargs.update(**mapData)
    return kwargs

views.PaymentDetailsView.get_context_data = get_context_data

def download_selected_orders(self, request, orders):
    response = HttpResponse(content_type='text/csv')
    response['Content-Disposition'] = 'attachment; filename=%s' \
        % self.get_download_filename(request)
    writer = UnicodeCSVWriter(open_file=response)

    metaData = (('number', _('Order number')),
                    ('value', _('Order value')),
                    ('date', _('Date of purchase')),
                    ('num_items', _('Number of items')),
                    ('status', _('Order status')),
                    ('customer', _('Customer email address')),
                    ('shipping_address_name', _('Deliver to name')),
                    ('billing_address_name', _('Bill to name')),
                    ('address', _('Address')),
                    ('phone', _('Phone')),
                    ('product', _('Product')),
                    )
    columns = SortedDict()
    for k, v in metaData:
        columns[k] = v

    writer.writerow(columns.values())
    for order in orders:
        row = columns.copy()
        row['number'] = order.number
        row['value'] = order.total_incl_tax
        row['date'] = format_datetime(order.date_placed, 'DATETIME_FORMAT')
        row['num_items'] = order.num_items
        row['status'] = order.status
        row['customer'] = order.email
        row['address'] = ''
        
        phone = '%s' % order.shipping_address.phone_number
        
        # #FIXME:
        # 目前電話去掉+886換0是給台灣用的
        row['phone'] = phone.replace('+886', '0')
        
        row['product'] = ''
        
        for field in order.shipping_address.active_address_fields():
            row['address'] += "%s \n" % field
        
        for i, line in enumerate(order.basket.lines.all(), 1):
            product = line.product
            attributes = product.attribute_summary
            description = line.description
            row['product'] += \
                "%d : %s(%s) X %d \n" % (i, description, 
                                            attributes, line.quantity)
        
        if order.shipping_address:
            row['shipping_address_name'] = order.shipping_address.name
        else:
            row['shipping_address_name'] = ''
        if order.billing_address:
            row['billing_address_name'] = order.billing_address.name
        else:
            row['billing_address_name'] = ''
        writer.writerow(row.values())
      
    if six.PY3:
        response.content = '\xEF\xBB\xBF' + response.content.decode('utf8')
    else:
        response.content = '\xEF\xBB\xBF' + response.content
    
    return response

OrderListView.download_selected_orders = download_selected_orders

# https://code.nuwainfo.com/trac/Mercurius/ticket/3155#ticket
from django.db import models

class OrderManager(models.Manager):
    def get_queryset(self):
        return Order._default_manager.exclude(status=u'測試用訂單')

Order.objects = OrderManager()

# https://code.nuwainfo.com/trac/Mercurius/ticket/3156#ticket
from django.core.mail import send_mail
from des.models import DynamicEmailConfiguration
from django.contrib.sites.models import Site
from oscar.apps.order.processing import EventHandler

def sendOrderEmail(order, subjectTemp, htmlTemp, txtTemp):
    try:
        temp = get_template(subjectTemp)
        ctx = Context({
            "order": order,
            "site": Site.objects.get(id=settings.SITE_ID)
        })
        subject = temp.render(ctx)
        
        temp = get_template(htmlTemp)
        htmlContent = temp.render(ctx)
                    
        temp = get_template(txtTemp)
        txtContent = temp.render(ctx)
        
        if order.user:
            email = order.user.email
        else:
            email = order.guest_email
                            
        success = send_mail(
            subject,
            txtContent,
            DynamicEmailConfiguration.objects.get().from_email,
            [email,],
            html_message=htmlContent,
            fail_silently=False,
        )
                            
        if success:
            logger.info("Send order email success: %s" % email)
        else:
            logger.error("Send order email fail: %s" % email)
    except Exception as e:
        logger.error("Error send order email: %s" % e)
        
def sandMessageToAdmin(subject, message):
    try:
        if hasattr(settings, 'IUNO_SHOP_SAND_MAIL_ADMINS'):
            emails = settings.IUNO_SHOP_SAND_MAIL_ADMINS
        else:
            User = get_user_model()
            staff = User.objects.filter(Q(is_staff=True) | Q(is_superuser=True))
            emails = [u.email for u in staff]
        
        if emails:
            send_mail(
                subject,
                message,
                DynamicEmailConfiguration.objects.get().from_email,
                emails,
                fail_silently=False,
            )
    except Exception as e:
        logger.error(
            "Error send order email: %s, %s, %s" % (str(e), subject, message))
    

def handle_order_status_change(self, order, new_status, note_msg=None):
    """
    Handle a requested order status change

    This method is not normally called directly by client code.  The main
    use-case is when an order is cancelled, which in some ways could be
    viewed as a shipping event affecting all lines.
    """
    order.set_status(new_status)

    hasSettings = hasattr(settings, 'OSCAR_PROCESSING_SEND_EMAIL_STATUS')
    
    if (hasSettings and 
        new_status == settings.OSCAR_PROCESSING_SEND_EMAIL_STATUS):
        sendOrderEmail(
            order, 
            'shop/customer/emails/BeingProcessedSubject.txt', 
            'shop/customer/emails/BeingProcessedBody.html', 
            'shop/customer/emails/BeingProcessedBody.txt'
        )
    hasSettings = hasattr(settings, 'OSCAR_ARRIVE_SEND_EMAIL_STATUS')
    
    if hasSettings and new_status == settings.OSCAR_ARRIVE_SEND_EMAIL_STATUS:
        sendOrderEmail(
            order, 
            'shop/customer/emails/ArriveSubject.txt', 
            'shop/customer/emails/ArriveBody.html', 
            'shop/customer/emails/ArriveBody.txt'
        )
        
    
    if note_msg:
        self.create_note(order, note_msg)

EventHandler.handle_order_status_change = handle_order_status_change

# ------------------------------------------------------------------------------
# /cathaybk/preview/
# /cathaybk-credit/checkxml/
@csrf_exempt
def returnCathaybkCreditXml(request):
    if request.POST:
        try:
            # get data
            xml = request.POST.get("strRsXML", None)
            if not xml:
                raise ValueError("Not strRsXM in post data.")

            root = etree.fromstring(utf8(xml))

            data = {}

            for child in root:
                if child.tag == "CAVALUE":
                    data["CAVALUE"] = child.text
                if child.tag in ["ORDERINFO", "AUTHINFO"]:
                    for child2 in child:
                        data[child2.tag] = child2.text

            #record data
            def parseDate(date):
                year = date[0:4]
                month = date[4:6]
                day = date[6:8]
                return "%s-%s-%s" % (year, month, day)

            if not data.get("AUTHCODE", ""):
                tradeNo = "NO_TRADE_NO"
            else:
                tradeNo = data.get("AUTHCODE", "NO_TRADE_NO")

            cathaybkCreditTrade = CathaybkCreditTrade.objects.create(
                tradeNo=tradeNo,
                tradeAmt=int(data.get("AMOUNT", "0")),
                merchantId=data.get("STOREID", ""),
                merchantTradeNo=data.get("ORDERNUMBER", ""),
                rtnCode=data.get("AUTHSTATUS", ""),
                paymentDate=parseDate(data.get("AUTHTIME", "11111111")),
                rtnMsg=data.get("AUTHMSG", ""),
                cardNo=data.get("CARDNO", ""),
            )
            cathaybkCreditTrade.save()

            # check
            status = data.get('AUTHSTATUS', None)
            if not status == '0000':
                raise ValueError("AUTHSTATUS: %s" % status)
        except Exception as e:
            logger.error('%s API ERROR: %s\n%s' % (
                    CATHAYBK_CREDIT, request.POST, str(e)))
        finally:
            # return xml
            scheme = request.scheme
            domain = request.META['HTTP_HOST']

            url = "%s://%s/%s/preview/" % (scheme, domain, CATHAYBK_CREDIT)

            checkValue = hashlib.md5(
                domain + settings.CATHAYBK_API_CUBKEY).hexdigest()
            
            temp = get_template('shop/payment/CathaybkReturn.xml')
            context = Context({
                'checkValue': checkValue,
                'returnUrl': url,
            })
            rtXml = temp.render(context)

            return HttpResponse(rtXml)
    else:
        logger.error("returnCathaybkCreditXml run to GET")
        scheme = request.scheme
        domain = request.META['HTTP_HOST']

        url = "%s://%s/%s/preview/" % (scheme, domain, CATHAYBK_CREDIT)

        checkValue = hashlib.md5(
            domain + settings.CATHAYBK_API_CUBKEY).hexdigest()
        
        temp = get_template('shop/payment/CathaybkReturn.xml')
        context = Context({
            'checkValue': checkValue,
            'returnUrl': url,
        })
        rtXml = temp.render(context)

        return HttpResponse(rtXml)
        
def sendPaymentForm(request):
    if request.method == 'POST':
        formData = request.POST.get("formData")
        request.session['preBasketId'] = request.basket.id
        request.basket.freeze()
        return render(
                request, 
                "shop/payment/PaymentRedirect.html", 
                {'form': base64.b64decode(formData),}
            )
    else:
        return Http404
    

class SuccessResponseView2(_PaymentDetailsView):
    preview = True
    http_method_names = ['post',]
    
    @method_decorator(csrf_exempt)
    def dispatch(self, request, *args, **kwargs):
        self.apiName = kwargs['name']
        return super(SuccessResponseView2, self).dispatch(request, 
                                                         *args, **kwargs)
                                                         
    @property
    def pre_conditions(self):
        return []
        
    def loadFrozenBasket(self, basketId):
        # Lookup the frozen basket that this txn corresponds to
        try:
            basket = Basket.objects.get(id=basketId, status=Basket.FROZEN)
        except Basket.DoesNotExist:
            return None

        # Assign strategy to basket instance
        if Selector:
            basket.strategy = Selector().strategy(self.request)

        # Re-apply any offers
        Applicator().apply(basket, self.request.user, request=self.request)

        return basket

    def get_pre_conditions(self, request):
        conditions = super(
            SuccessResponseView2, self).get_pre_conditions(request)
        if self.apiName == ECPAY_MAP:
            conditions = [
                'check_basket_is_not_empty',
                'check_basket_is_valid',
                'check_user_email_is_captured',
            ]
        return conditions

    def post(self, request, *args, **kwargs):
        # apiName
        self.apiName = kwargs['name']
        
        if not self.apiName in [
            SPGATEWAY, ALLPAY, ECPAY, CATHAYBK_CREDIT, 
            CATHAYBK_CUP, ECPAY_MAP, ECPAY_LOGISTIC]:
            raise ValueError("Not pay api name: %s" % apiName)

        try:
            if self.apiName in [ALLPAY, ECPAY]:
                # data
                self.tradeNo = request.POST.get('TradeNo')
                self.tradeAmt = request.POST.get('TradeAmt')
                self.merchantID = request.POST.get('MerchantID')
                self.merchantTradeNo = request.POST.get('MerchantTradeNo')
                self.rtnCode = request.POST.get('RtnCode')
                self.rtnMsg = request.POST.get('RtnMsg')
                self.payAmt = request.POST.get('MerchantID')
                self.tradeDate = request.POST.get('TradeDate')
                self.paymentType = request.POST.get('PaymentType')
                self.simulatePaid = request.POST.get('SimulatePaid')
                self.paymentDate = request.POST.get('PaymentDate')
                self.paymentTypeChargeFee = request.POST.get(
                                                        'PaymentTypeChargeFee')

                # basket
                index = request.POST.get('MerchantTradeNo').find('BASKETID')
                self.basketId = int(
                                request.POST.get('MerchantTradeNo')[index + 8:])

                # error
                if self.apiName == ALLPAY:
                    result = not str(self.rtnCode) == str(0)
                else:
                    result = self.rtnMsg == 'ERROR'
                if result:
                    msg = _(
                        "There was an error in the payment. Please try again.")
                    messages.error(self.request, msg)
                    logger.error(
                        '%s API ERROR: %s' % (self.apiName, request.POST))
                    return redirect('checkout:payment-details')
            
                # record trade data
                if self.apiName == ECPAY:
                    ecpayTrade = ECPayTrade.objects.create(
                        tradeNo=self.tradeNo,
                        tradeAmt=int(self.tradeAmt),
                        merchantId=self.merchantID,
                        merchantTradeNo=self.merchantTradeNo,
                        rtnCode=self.rtnCode,
                        payAmt=int(self.payAmt),
                        tradeDate=self.tradeDate.replace('/', '-'),
                        paymentType=self.paymentType,
                        simulatePaid=self.simulatePaid,
                        paymentDate=self.paymentDate.replace('/', '-'),
                        paymentTypeChargeFee=self.paymentTypeChargeFee,
                        rtnMsg=self.rtnMsg,
                    )
                    ecpayTrade.save()
                else:
                    allpayTrade = AllPayTrade.objects.create(
                        tradeNo=self.tradeNo,
                        tradeAmt=int(self.tradeAmt),
                        merchantId=self.merchantID,
                        merchantTradeNo=self.merchantTradeNo,
                        rtnCode=self.rtnCode,
                        payAmt=int(self.payAmt),
                        tradeDate=self.tradeDate.replace('/', '-'),
                        paymentType=self.paymentType,
                        simulatePaid=self.simulatePaid,
                        paymentDate=self.paymentDate.replace('/', '-'),
                        paymentTypeChargeFee=self.paymentTypeChargeFee,
                        rtnMsg=self.rtnMsg,
                    )
                    allpayTrade.save()
            elif self.apiName == SPGATEWAY:
                # data
                data = json.loads(request.POST.get('JSONData', '{}'))
                
                self.status = data.get('Status')
                self.message = data.get('Message')
                self.result = json.loads(data.get('Result', '{}'))
                self.tradeNo = self.result.get("TradeNo")
                self.tradeAmt = self.result.get("Amt")
                self.merchantID = self.result.get("MerchantID")
                self.merchantTradeNo = self.result.get("MerchantOrderNo")
                self.rtnCode = self.result.get("RespondCode")
                self.tradeDate = self.result.get("PayTime")
                self.paymentMethod = self.result.get("PaymentMethod")
                self.paymentType = self.result.get("PaymentType")
                
                # basket
                index = self.result.get('MerchantOrderNo').find('BASKETID')
                self.basketId = int(
                    self.result.get('MerchantOrderNo')[index + 8:])

                # error
                if not self.status == 'SUCCESS':
                    msg = _(
                        "There was an error in the payment. Please try again.")
                    messages.error(self.request, msg)
                    logger.error(
                        '%s API ERROR: %s' % (self.apiName, request.POST))
                    return redirect('checkout:payment-details')

                # record trade data
                spgatewayTrade = SpgatewayTrade.objects.create(
                    tradeNo=self.tradeNo,
                    tradeAmt=int(self.tradeAmt),
                    merchantId=self.merchantID,
                    merchantTradeNo=self.merchantTradeNo,
                    rtnCode=self.rtnCode,
                    paymentDate=self.tradeDate.replace('/', '-'),
                    paymentType=self.paymentType,
                    paymentMethod=self.paymentMethod,
                    rtnMsg=self.message,
                )
                spgatewayTrade.save()
            elif self.apiName == CATHAYBK_CREDIT:
                self.status = 'XXXX'
                msg = _("There was an error in the payment. Please try again.")

                # get data
                xml = request.POST.get("strRsXML", None)
                if not xml:
                    logger.error(
                        "Not strRsXML in post data.: %s" % request.POST)
                    messages.error(self.request, msg)
                    return redirect('checkout:payment-details')

                root = etree.fromstring(utf8(xml))
                data = {}
                for child in root:
                    if child.tag == "CAVALUE":
                        data["CAVALUE"] = child.text
                    if child.tag in ["ORDERINFO",]:
                        for child2 in child:
                            data[child2.tag] = child2.text

                # get obj & check
                self.merchantTradeNo = data.get("ORDERNUMBER", "")
                if not CathaybkCreditTrade.objects.filter(
                        merchantTradeNo=self.merchantTradeNo).exists():
                    messages.error(self.request, msg)
                    return redirect('checkout:payment-details')
                cathaybkCreditTrade = CathaybkCreditTrade.objects.get(
                    merchantTradeNo=self.merchantTradeNo)
                self.status = cathaybkCreditTrade.rtnCode
                if not cathaybkCreditTrade.rtnCode == '0000':
                    messages.error(
                        self.request, 
                        msg + ": %s %s" % (cathaybkCreditTrade.rtnCode, 
                                           cathaybkCreditTrade.rtnMsg))
                    return redirect('checkout:payment-details') 

                # data
                index = cathaybkCreditTrade.merchantTradeNo.find('BASKETID')
                self.basketId = int(
                    cathaybkCreditTrade.merchantTradeNo[index + 8:])

                self.tradeNo = cathaybkCreditTrade.tradeNo
                self.tradeAmt = cathaybkCreditTrade.tradeAmt
            elif self.apiName == ECPAY_MAP:
                if hasattr(settings, "ECPAY_API_LOGISTIC_SUB_TYPES"):
                    subTypes = settings.ECPAY_API_LOGISTIC_SUB_TYPES
                else:
                    subTypes = {
                        "FAMI": u"全家便利商店",
                        "UNIMART": u"統一7-11超商" ,
                        "HILIFE": u"萊爾富",
                    }

                extra = request.POST.get("ExtraData")
                # 防呆 or submission 內會有地址資料
                splitData = extra.split(",")
                name = splitData[1][len("name="):]
                phone = splitData[0][len("phone="):]

                data = {
                    'storeName': self.request.POST.get('CVSStoreName'),
                    'storeAddress': self.request.POST.get('CVSAddress'),
                    'storeTypeName': subTypes[
                        self.request.POST.get('LogisticsSubType')],
                    'storeId': request.POST.get("CVSStoreID"),
                    'storeType': self.request.POST.get('LogisticsSubType'),
                    'storePhone': self.request.POST.get('CVSTelephone'),
                    'receiverName': name,
                    'receiverPhone': phone,
                }

                #FIXME: phone 判斷
                pyPhone = to_python(
                    data['receiverPhone'].replace('09', '+8869'))

                addressData = {
                    "first_name": " ", 
                    "last_name": data['receiverName'],
                    
                    "country_id": u'TW', 
                    "line4": data['storeAddress'], 
                    "line1": "%s%s" % (
                        data['storeTypeName'], data['storeName']),
                    'line3': u'', 
                    'line2': u'',
                    "postcode": '00000', 
                    "phone_number": pyPhone,
                    'notes': u'',
                    'state': u'',
                    'search_text': u'',
                    'title': u'',  
                    'id': None,          
                }
                
                self.checkout_session.ship_to_new_address(addressData)
                
                self.request.session['logisticMap'] = json.dumps(data)
               
                return redirect("checkout:payment-method")

            elif self.apiName == ECPAY_LOGISTIC:
                # data 
                errorMsg = None
                try:
                    self.tradeNo = request.POST.get('AllPayLogisticsID')
                    self.tradeAmt = request.POST.get('GoodsAmount')

                    self.merchantTradeNo = request.POST.get('MerchantTradeNo')
                    index = self.merchantTradeNo.find('BASKETID')
                    self.basketId = int(self.merchantTradeNo[index + 8:])

                    self.merchantID = request.POST.get('MerchantID')
                    self.rtnCode = request.POST.get('RtnCode')
                    self.rtnMsg = request.POST.get('RtnMsg')
                    
                    self.updateStatusDate = request.POST.get('UpdateStatusDate')
                    self.receiverName = request.POST.get('ReceiverName')
                    self.receiverCellPhone = request.POST.get(
                                                'ReceiverCellPhone')
                    self.receiverEmail = request.POST.get('ReceiverEmail')
                    self.logisticsType = request.POST.get('LogisticsType')
                    self.logisticsSubType = request.POST.get('LogisticsSubType')

                    self.paymentNo = request.POST.get('CVSPaymentNo')
                    self.validationNo = request.POST.get('CVSValidationNo')
                    
                    # error
                    if self.rtnMsg == 'ERROR':
                        msg = _(
                            "There was an error in the payment. "
                            "Please try again.")
                        messages.error(self.request, msg)
                        logger.error(
                            '%s API ERROR: %s' % (self.apiName, request.POST))
                        return redirect('checkout:payment-details')

                    # record
                    logisticTrade = ECPayLogisticTrade.objects.create(
                        tradeNo=self.tradeNo,
                        tradeAmt=int(self.tradeAmt),
                        merchantId=self.merchantID,
                        merchantTradeNo=self.merchantTradeNo,
                        rtnCode=self.rtnCode,
                        rtnMsg=self.rtnMsg,
                        tradeDate=self.updateStatusDate.replace('/', '-'),
                        updateStatusDate= \
                            self.updateStatusDate.replace('/', '-'),
                        receiverName=self.receiverName,
                        receiverCellPhone=self.receiverCellPhone,
                        receiverEmail=self.receiverEmail,
                        logisticsType=self.logisticsType,
                        logisticsSubType=self.logisticsSubType,
                        paymentNo=self.paymentNo,
                        validationNo=self.validationNo,
                    )

                    if self.request.session.get('paymentData'):
                        paymentData = json.loads(
                            self.request.session.get('paymentData'))
                        self.apiName = paymentData['apiName']
                        self.tradeNo = "%s|%s" % (
                            paymentData['tradeNo'], self.tradeNo)
                except Exception as e:
                    errorMsg = str(e)
                    logger.error(errorMsg)
                finally:
                    # delete session data
                    if self.request.session.get('paymentData'):
                        del self.request.session['paymentData']
                    if self.request.session.get('logisticMap'):
                        del self.request.session['logisticMap']
                    if errorMsg:
                        msg = _(
                            "There was an error in the payment. "
                            "Please try again.")
                        messages.error(self.request, msg)
                        return redirect('checkout:payment-details')


            if self.request.session.get('logisticMap'):
                submission = super(
                    SuccessResponseView2, self).build_submission(**kwargs)
                form = buildAPIForm(
                    submission, 
                    self.request, 
                    ECPAY_LOGISTIC,
                    extra={"isCollection": "N",},
                )

                paymentData = {
                    'apiName': self.apiName,
                    'tradeNo': self.tradeNo,
                }
                self.request.session['paymentData'] = json.dumps(paymentData)

                ctx = {
                    'form': form,
                }
                return render(
                    request, 'shop/payment/LogisticRedirect.html', ctx)
            
            # ECPAY_LOGISTIC 不需要 loadFrozenBasket
            if not self.apiName == ECPAY_LOGISTIC:
                errorMsg = _(
                    "A problem occurred communicating with %(apiName)s "
                    "- please try again later"
                ) % {"apiName": self.apiName}
                self._basket = self.loadFrozenBasket(self.basketId)
                if not self._basket:
                    messages.error(self.request, errorMsg)
                    return redirect('checkout:payment-details')
            else:
                self._basket = request.basket
             
            return self.handle_place_order_submission(request)
        except Exception as e:
            # return msg
            logger.error(str(e))

            # raise
            if settings.SERVER_MODE == DEVELOPMENT:
                raise
            
            # if payment success
            msg1 = _("There was an except error in the payment."
                     " We have notified the administrator to deal with refund.")

            # if payment not success
            msg2 = _("There was an error in the payment. Please try again.")

            # call admin
            if self.apiName == ALLPAY:
                if not self.rtnMsg == 'ERROR':
                    if not AllPayTrade.objects.filter(
                        merchantTradeNo=self.merchantTradeNo).exists():
                        logger.error(
                            '%s API ERROR(this need to refund):\n%s\n%s' % (
                                self.apiName, request.POST, str(e)))
                        messages.error(self.request, msg1)
                    else:
                        logger.error(str(e))
                        order = Order.objects.get(basket=request.basket)
                        url = "%s?order_id=%d" % (
                            reverse('checkout:thank-you'), order.id)
                        return redirect(url)
                else:
                    logger.error(
                        '%s API ERROR:\n%s\n%s' % (
                            self.apiName, request.POST, str(e)))
                    messages.error(self.request, msg2)
            elif self.apiName == ECPAY:
                if not self.rtnMsg == 'ERROR':
                    if not ECPayTrade.objects.filter(
                        merchantTradeNo=self.merchantTradeNo).exists():
                        logger.error(
                            '%s API ERROR(this need to refund):\n%s\n%s' % (
                                self.apiName, request.POST, str(e)))
                        messages.error(self.request, msg1)
                    else:
                        logger.error(str(e))
                        order = Order.objects.get(basket=request.basket)
                        url = "%s?order_id=%d" % (
                            reverse('checkout:thank-you'), order.id)
                        return redirect(url)
                else:
                    logger.error(
                        '%s API ERROR:\n%s\n%s' % (
                            self.apiName, request.POST, str(e)))
                    messages.error(self.request, msg2)
            elif self.apiName == SPGATEWAY:
                if self.status == 'SUCCESS':
                    if not SpgatewayTrade.objects.filter(
                        merchantTradeNo=self.merchantTradeNo).exists():
                        logger.error(
                            '%s API ERROR(this need to refund):\n%s\n%s' % (
                                self.apiName, request.POST, str(e)))
                        messages.error(self.request, msg1)
                    else:
                        logger.error(str(e))
                        order = Order.objects.get(basket=request.basket)
                        url = "%s?order_id=%d" % (
                            reverse('checkout:thank-you'), order.id)
                        return redirect(url)
                else:
                    logger.error(
                        '%s API ERROR:\n%s\n%s' % (
                            self.apiName, request.POST, str(e)))
                    messages.error(self.request, msg2)
            

            return redirect('checkout:payment-details')
        
        
    def build_submission(self, **kwargs):
        kwargs['basket'] = self._basket
        
        submission = super(
            SuccessResponseView2, self).build_submission(**kwargs)
        
        
        submission['payment_kwargs']['tradeNo'] = self.tradeNo
        submission['payment_kwargs']['tradeAmt'] = self.tradeAmt
        submission['payment_kwargs']['basketId'] = self.basketId
        return submission

    
    def handle_payment(self, order_number, total, **kwargs):
        tradeAmt = int(kwargs['tradeAmt'])
        tradeNo = kwargs['tradeNo']
        source_type, is_created = SourceType.objects.get_or_create(
            name=self.apiName)
        source = Source(source_type=source_type,
                        currency='TWD',
                        amount_allocated=tradeAmt,
                        amount_debited=tradeAmt,
                        reference=tradeNo) 
        
        self.add_payment_source(source)
        self.add_payment_event('Settled', tradeAmt,
                               reference=tradeNo)

class ECPayLogisticreturnView(generic.View):

    http_method_names = ['get', 'post',]

    def get(self, request, *args, **kwargs):
        orderNumber = kwargs.get('orderNumber')
        order = get_object_or_404(Order, number=orderNumber)
        source = Source.objects.get(order=order)
        tradeNo = source.reference.split("|")
        if len(tradeNo) == 2: # tradeNo|tradeNo
            tradeNo = tradeNo[1]
        else:
            tradeNo = tradeNo[0]

        trade = ECPayLogisticTrade.objects.filter(
                    tradeNo=tradeNo).order_by('-id').first()
        
        return render(
            request, 
            "shop/payment/EcpayReturn.html",
            {
                'order': order,
                'trade': trade,
            }
        )

    def post(self, request, *args, **kwargs):
        orderNumber = kwargs.get('orderNumber')
        order = get_object_or_404(Order, number=orderNumber)
        source = Source.objects.get(order=order)
        tradeNo = source.reference.split("|")
        if len(tradeNo) == 2: # tradeNo|tradeNo
            tradeNo = tradeNo[1]
        else:
            tradeNo = tradeNo[0]
            
        trade = ECPayLogisticTrade.objects.filter(
                    tradeNo=tradeNo).order_by('-id').first()
       
        data = {
            'MerchantID': trade.merchantId,
            'ServerReplyURL': reverse("ecpayLogisticReply"),
            'GoodsAmount': trade.tradeAmt,
            #'GoodsName': "Reference ",
            'ServiceType': 4, # 退貨不付款
            'SenderName': trade.receiverName,
            'SenderPhone': trade.receiverCellPhone,
            'AllPayLogisticsID': trade.tradeNo,
        }

        apiUrls = {
            "FAMI": {
                "stage": ("https://logistics-stage.ecpay.com.tw/"
                         "express/ReturnCVS"),
                "production": ("https://logistics-stage.ecpay.com.tw/"
                               "express/ReturnCVS"), 
            },
            "UNIMART": {
                "stage": ("https://logistics-stage.ecpay.com.tw/"
                          "express/ReturnUniMartCVS"),
                "production": ("https://logistics.ecpay.com.tw/"
                               "express/ReturnUniMartCVS"), 
            },
            "HILIFE": {
                "stage": ("https://logistics-stage.ecpay.com.tw/"
                          "express/ReturnHiLifeCVS"),
                "production": ("https://logistics.ecpay.com.tw/"
                               "express/ReturnHiLifeCVS"), 
            },
        }

        if settings.ECPAY_SANDBOX_MODE:
            apiUrl = apiUrls[trade.logisticsSubType]["stage"]
        else:
            apiUrl = apiUrls[trade.logisticsSubType]["production"]

        data["CheckMacValue"] = createCheckValue(data)

        res = requests.post(apiUrl, data=data)

        if not "ErrorMessage" in res.text:
            messages.success(self.request, u"成功送出退貨訊息")
            rtnMerchantTradeNo = res.text.split("|")[0]
            rtnOrderNo = res.text.split("|")[1]

            newLogisticTrade = ECPayLogisticTrade.objects.create(
                tradeNo=trade.tradeNo,
                tradeAmt=int(trade.tradeAmt),
                merchantId=trade.merchantId,
                merchantTradeNo=trade.merchantTradeNo,
                rtnCode=100,
                rtnMsg=u"已送出退貨資料",
                tradeDate=trade.tradeDate,
                updateStatusDate=timezone.now(),
                receiverName=trade.receiverName,
                receiverCellPhone=trade.receiverCellPhone,
                receiverEmail=trade.receiverEmail,
                logisticsType=trade.logisticsType,
                logisticsSubType=trade.logisticsSubType,
                paymentNo=trade.paymentNo,
                validationNo=trade.validationNo,

                rtnMerchantTradeNo=rtnMerchantTradeNo,
                rtnOrderNo=rtnOrderNo,
            )

            order.status = settings.OSCAR_ORDER_RETURN_STATUS
            order.save()

            return redirect('customer:order-list')
        else:
            messages.error(self.request, u"送出退貨訊息失敗")
            return redirect('customer:order-list')


class ECPayServerReplyView(generic.View):

    http_method_names = ['get', 'post',]

    @csrf_exempt
    def dispatch(self, request, *args, **kwargs):
        return super(ECPayServerReplyView, self).dispatch(
            request, *args, **kwargs)

    def get(self, request, *args, **kwargs):
        logger.warn("GET: %s" % (request.GET))
        return render("|ErrorMessage")

    def post(self, request, *args, **kwargs):
        logger.warn("POST: %s" % (request.POST))
        # data 
        try:
            self.tradeNo = request.POST.get('AllPayLogisticsID')
            self.tradeAmt = request.POST.get('GoodsAmount')

            self.merchantTradeNo = request.POST.get('MerchantTradeNo')

            self.merchantID = request.POST.get('MerchantID')
            self.rtnCode = request.POST.get('RtnCode')
            self.rtnMsg = request.POST.get('RtnMsg')
            
            self.updateStatusDate = request.POST.get('UpdateStatusDate')
            self.receiverName = request.POST.get('ReceiverName')
            self.receiverCellPhone = request.POST.get('ReceiverCellPhone')
            self.receiverEmail = request.POST.get('ReceiverEmail')
            self.logisticsType = request.POST.get('LogisticsType')
            self.logisticsSubType = request.POST.get('LogisticsSubType')

            self.rtnMerchantTradeNo = request.POST.get('RtnMerchantTradeNo')

            self.paymentNo = request.POST.get('CVSPaymentNo')
            self.validationNo = request.POST.get('CVSValidationNo')

            if self.rtnMerchantTradeNo:
                logisticTrade = ECPayLogisticTrade.objects.filter(
                    tradeNo=self.tradeNo).order_by('-id').first()

                newLogisticTrade = ECPayLogisticTrade.objects.create(
                    tradeNo=self.tradeNo,
                    tradeAmt=int(self.tradeAmt),
                    merchantId=self.merchantID,
                    merchantTradeNo=self.merchantTradeNo,
                    rtnCode=self.rtnCode,
                    rtnMsg=self.rtnMsg,
                    tradeDate=logisticTrade.tradeDate,
                    updateStatusDate=self.updateStatusDate.replace('/', '-'),
                    receiverName=self.receiverName,
                    receiverCellPhone=self.receiverCellPhone,
                    receiverEmail=self.receiverEmail,
                    logisticsType=self.logisticsType,
                    logisticsSubType=self.logisticsSubType,
                    paymentNo=self.paymentNo,
                    validationNo=self.validationNo,
                    rtnMerchantTradeNo=self.rtnMerchantTradeNo,
                )
                
                return HttpResponse("1|OK")
            else:
                index = self.merchantTradeNo.find('BASKETID')
                self.basketId = int(self.merchantTradeNo[index + 8:])

                order = Order.objects.get(basket=self.basketId)
                
                site = get_current_site(request)
                siteName = site.name
                
                if self.rtnCode in ['2030', '3024',]:
                    order.status = settings.OSCAR_ORDER_PROCESSING_STATUS
                elif self.rtnCode in ['2063', '3018', '2073',]:
                    order.status = settings.OSCAR_ORDER_ARRIVE_STATUS
                elif self.rtnCode in ['2067', '3022']:
                    order.status = settings.OSCAR_ORDER_COMPLETE_STATUS
                elif self.rtnCode in ['2074', '3020']:
                    order.status = settings.OSCAR_ORDER_RETURN_STATUS
                else:
                    return HttpResponse("|ErrorMessage")
                order.save()
                
                sandMessageToAdmin(
                    _("[%(site)s]Logistic order status change") % {
                        'site': siteName,
                    },
                    _("Logistic order %(orderNumber)s"
                      " has changed to %(status)s") % {
                        'orderNumber': order.number, 
                        'status': order.status,
                    },
                )
                
                hasSettings = hasattr(
                    settings, 'OSCAR_PROCESSING_SEND_EMAIL_STATUS')
                if (hasSettings and 
                    order.status == \
                        settings.OSCAR_PROCESSING_SEND_EMAIL_STATUS):
                    sendOrderEmail(
                        order, 
                        'shop/customer/emails/BeingProcessedSubject.txt', 
                        'shop/customer/emails/BeingProcessedBody.html', 
                        'shop/customer/emails/BeingProcessedBody.txt'
                    )
                hasSettings = hasattr(
                    settings, 'OSCAR_ARRIVE_SEND_EMAIL_STATUS')
                if (hasSettings and 
                    order.status == settings.OSCAR_ARRIVE_SEND_EMAIL_STATUS):
                    sendOrderEmail(
                        order, 
                        'shop/customer/emails/ArriveSubject.txt', 
                        'shop/customer/emails/ArriveBody.html', 
                        'shop/customer/emails/ArriveBody.txt'
                    )

                logisticTrade = ECPayLogisticTrade.objects.filter(
                    tradeNo=self.tradeNo).order_by('-id').first()

                newLogisticTrade = ECPayLogisticTrade.objects.create(
                    tradeNo=self.tradeNo,
                    tradeAmt=int(self.tradeAmt),
                    merchantId=self.merchantID,
                    merchantTradeNo=self.merchantTradeNo,
                    rtnCode=self.rtnCode,
                    rtnMsg=self.rtnMsg,
                    tradeDate=logisticTrade.tradeDate,
                    updateStatusDate=self.updateStatusDate.replace('/', '-'),
                    receiverName=self.receiverName,
                    receiverCellPhone=self.receiverCellPhone,
                    receiverEmail=self.receiverEmail,
                    logisticsType=self.logisticsType,
                    logisticsSubType=self.logisticsSubType,
                    paymentNo=self.paymentNo,
                    validationNo=self.validationNo,
                )

                return HttpResponse("1|OK")
        except Exception as e:
            logger.error(str(e))
            return HttpResponse("|ErrorMessage")





class ECPayTransactionListView(generic.ListView):
    model = ECPayTrade
    template_name = 'shop/payment/dashboard/ECPay.html'
    context_object_name = 'transactions'

    def get_queryset(self):
        return super(
            ECPayTransactionListView, self).get_queryset().order_by('-id')

class AllPayTransactionListView(generic.ListView):
    model = AllPayTrade
    template_name = 'shop/payment/dashboard/AllPay.html'
    context_object_name = 'transactions'

    def get_queryset(self):
        return super(
            AllPayTransactionListView, self).get_queryset().order_by('-id')

class SpgatewayTransactionListView(generic.ListView):
    model = SpgatewayTrade
    template_name = 'shop/payment/dashboard/Spgateway.html'
    context_object_name = 'transactions'

    def get_queryset(self):
        return super(
            SpgatewayTransactionListView, self).get_queryset().order_by('-id')

class CathaybkCreditTransactionListView(generic.ListView):
    model = CathaybkCreditTrade
    template_name = 'shop/payment/dashboard/CathayCredit.html'
    context_object_name = 'transactions'

    def get_queryset(self):
        return super(
            CathaybkCreditTransactionListView, self
            ).get_queryset().order_by('-id')

class ECPayLogisticTransactionListView(generic.ListView):
    model = ECPayLogisticTrade
    template_name = 'shop/payment/dashboard/ECPayLogistic.html'
    context_object_name = 'transactions'

    def get_queryset(self):
        return super(
            ECPayLogisticTransactionListView, self
            ).get_queryset().order_by('-id')
    
# https://code.nuwainfo.com/trac/phantasos/ticket/589#ticket
from oscar.apps.dashboard.catalogue import tables
from oscar.apps.dashboard.catalogue import views as catalogueViews
from oscar.core.loading import get_model
from django_tables2 import A, TemplateColumn
from django.utils.translation import ugettext_lazy as _

Product = get_model('catalogue', 'Product')

class ProductTable(tables.ProductTable):
    categories = TemplateColumn(
        verbose_name=_('Categories'),
        accessor=A('categories'),
        template_name='shop/dashboard/catalogue/ProductRowCategory.html',
        orderable=False,
    )

    class Meta(tables.ProductTable.Meta):
        model = Product
        fields = ('upc', 'date_updated')
        sequence = ('title', 'upc', 'image', 'product_class', 
                    'categories', 'variants',
                    'stock_records', '...', 'date_updated', 'actions')
        order_by = '-date_updated'
        
catalogueViews.ProductListView.table_class = ProductTable

    

        
    


