#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: emails.py 1288 2016-08-03 08:25:39Z Eric $
#
# Copyright (c) 2016 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Eric $ (last)
# $Date: 2016-08-03 16:25:39 +0800 (Wed, 03 Aug 2016) $
# $Revision: 1288 $

import collections
import json
import urllib
import urllib2

from Iuppiter.Encoding import utf8

class SMS(object):

    def __init__(self, phones, message, username='', password='',
                 date=None, hour=None, min=None, **kws):
        """         
        Constructor.
        
        @param phones List of the phone numbers that you want to send.
        @param message Message.
        @param username Your username.
        @param password Your password.
        @param date Send date if method is 'reserved'. Format: YYYY/MM/DD
        @param hour Send hour if method is 'reserved'. Format: 00~23
        @param min Send date if min is 'reserved'. Format: 00~59
        """
        if isinstance(phones, basestring):
            self.phoneLists = [str(phones)]
        else:
            self.phoneLists = phones
            
        if isinstance(phones, collections.Iterable):
            #http://stackoverflow.com/questions/1952464/
            #in-python-how-do-i-determine-if-an-object-is-iterable
            self.phoneLists = [
                self.phoneLists[x: x + 250] for x in range(0, len(phones), 250)
            ]
            self.phoneLists = [','.join(l) for l in self.phoneLists]
            
        else:
            raise ValueError("phones must be iterable or a string")
        
        if date != None or hour != None or min != None:
            self.postData = [
                ('username', username if username else 'nuwa'),
                ('password', password if password else 'nuwa25025529'),
                ('method', "2"),
                ('sms_msg', utf8(message)),
                ('send_date', date),
                ('hour', hour),
                ('min', min),
            ]
        else:
            self.postData = [
                ('username', username if username else 'nuwa'),
                ('password', password if password else 'nuwa25025529'),
                ('method', "1"),
                ('sms_msg', utf8(message))
            ]

        self.result = None
        self.resultDetails = []
    
    def sendMessage(self):
        """
        Send SMS message.
        
        return Sms sent result string. Format: {"stats":true,
                                                "error_code":"000",
                                                "error_msg":"1646437|1|2"}
        """
        for phones in self.phoneLists:

            phoneData = ('phone', str(phones))
            postData = self.postData
            postData.append(phoneData)
            
            try:
                result = urllib2.urlopen(
                            'http://sms-get.com/api_send.php?' + \
                            urllib.urlencode(postData)
                         )
            except Exception, e:
                result = '{"stats":false,'+ \
                         '"error_code":"-999",' + \
                         '"error_msg": "%s"}' % str(e)
                         
            self.resultDetails.append(json.loads(result.read()))

        self.setResult()
        
        return self.result
        
    
    def getSendingDetails(self):
        '''
        Get sending message detailed results.
        
        
        @return Result details.
        '''
        
        return self.resultDetails
        
    def setResult(self):
        '''
        Set sending message result.
        
        '''
        result = True
        for r in self.resultDetails:
            if r['error_code'] != '000':
                result = False
                break
        
        self.result = result
        