# -*- coding: utf-8 -*-
# Generated by Django 1.11.20 on 2020-03-19 06:34
from __future__ import unicode_literals

import django.core.validators
from django.db import migrations, models
import django.db.models.manager
from Iuno.shop.models import BonusRecordManager

def recordBonus(apps, schemaEditor):
    try:
        BonusRecord = apps.get_model('shop', 'BonusRecord')
        Bonus = apps.get_model('shop', 'Bonus')
    except:
        # do nothing
        return
    
    for b in Bonus.objects.all():      
        bonusRecords = BonusRecord.objects.filter(user=b.user).order_by('createdTime')
        
        for record in bonusRecords:
            BonusRecord.objects.recordUsingBonus(record, adjust=True)
    
        
class Migration(migrations.Migration):

    dependencies = [
        ('shop', '0018_auto_20200108_2106'),
    ]

    operations = [
        migrations.AlterModelManagers(
            name='bonusrecord',
            managers=[
                ('objects', BonusRecordManager()),
            ],
        ),
        migrations.AddField(
            model_name='bonusrecord',
            name='usedBonus',
            field=models.IntegerField(default=0, verbose_name='Used bonus'),
        ),
         migrations.AddField(
            model_name='bonusrecord',
            name='expiredBonus',
            field=models.IntegerField(default=0, verbose_name='Expired bonus'),
        ),
        migrations.AddField(
            model_name='bonussettings',
            name='expiryDays',
            field=models.IntegerField(default=-1, validators=[django.core.validators.MinValueValidator(-1)], verbose_name='Expiry days(-1 is no limit)'),
        ),
        migrations.RunPython(recordBonus),
    ]
