#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: setup.py 11749 2019-10-14 10:16:28Z Andy $
#
# Copyright (c) 2016 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Andy $ (last)
# $Date: 2019-10-14 18:16:28 +0800 (週一, 14 十月 2019) $
# $Revision: 11749 $

import os
import warnings

try:
    from Iuppiter.DistUtil import setup
    from Iuppiter.Util import colored
except ImportError:
    os.system('pip install Iuppiter --no-cache-dir')
    from Iuppiter.DistUtil import setup
    from Iuppiter.Util import colored
    
import sys

if sys.version_info.major == 3:
    if sys.version_info[:2] >= (3, 6):
        extraRequirements = [
            'pip install mysqlclient==1.4.2.post1',
        ]
    else:
        extraRequirements = [
            'pip install mysqlclient==1.3.12',
        ]
    extraRequirements.extend([
        'pip install raven==6.10.0',
        # celery 安裝 4.3 cloud 寄信時 Asynchronous 會出現 Send message failed, 
        # reason: 'NoneType' object is not callable
        'pip install celery==4.2.2',
        'pip install amqp==2.4.2',
        'pip install redis==3.2.1'])
else:
    extraRequirements = [
        'pip install mysqlclient==1.3.7',
        'pip install raven==4.0.4',
        'pip install celery==3.1.25',
        'pip install amqp==1.4.9',
        'pip install redis==2.10.3'
    ]

from sys import platform as _platform

# Python for Window Extensions (pypiwin32) is only for Windows.
if _platform == "win32":
    # win32 (https://pypi.python.org/pypi/pypiwin32/219)
    extraRequirements.append('pip install pypiwin32')   

# 要改版本號，請去改 Iuno.Version
import six

if six.PY2:
    kwargs = {}
else:
    kwargs = {'encoding': 'utf8',}
    
with open(os.path.join('Iuno', 'Version.py'), **kwargs) as f:
    content = f.read()
    exec(content)    

setup(
    'Iuno',
    description="Support package for all Nuwa Information's server projects.",
    version=IUNO_VERSION,
    license='Proprietary License',
    author='Bear',
    author_email='bear@nuwainfo.com',
    url='http://www.nuwainfo.com/',
	extraRequirements=extraRequirements,
    extrasRequire={
        'scrapy': "REQUIREMENTS_SCRAPY.txt",
    }
)
