# Install cron jobs.
mkdir -p cron

if (( $(env | grep -c "CONDA_DEFAULT_ENV=" ) == 0 )) ; then
    echo '#!/bin/bash
source $HOME/app/bin/activate
cd /home/nuwa/app/$APP_NAME

{{ command|safe|escape }}
' > cron/{{ jobName }}
else
    echo '#!/bin/bash
. /home/nuwa/.bashrc
conda activate /home/nuwa/app

cd /home/nuwa/app/$APP_NAME

{{ command|safe|escape }}
' > cron/{{ jobName }}
fi

sed -i -e "s#\$HOME#$HOME#g" cron/{{ jobName }}
sed -i -e "s#\$PWD#$PWD#g" cron/{{ jobName }}
chmod +x cron/{{ jobName }}

if (( $(crontab -l | grep -c "{{ hchk }}" ) == 0 )) ; then
    crontab -l > _cron
    if (( $(crontab -l | grep -c "APP_NAME=" ) == 0 )) ; then
        env >> _cron
    fi
    mkdir -p $HOME/app/log/{{ jobName }}/
    echo "{{ time }} $PWD/cron/Crontask.sh -i {{ hchk }} -l $HOME/app/log/{{ jobName }}/ null null cmd "\""$PWD/cron/{{ jobName }}"\""" >> _cron
    if crontab _cron; then
        rm -rf _cron
    else
        rm -rf _cron
        exit 1
    fi
else
    echo "Job existed. Nothing to do"
fi