#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: path.py 11393 2019-03-22 03:11:49Z Kevin $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Kevin $ (last)
# $Date: 2019-03-22 11:11:49 +0800 (週五, 22 三月 2019) $
# $Revision: 11393 $

import os
import datetime

from dateutil import parser

from Iuno.cloud.storage.gos.Service import getFile, BY_PATH

try:
    FileNotFoundError
except NameError:
    FileNotFoundError = IOError

splitext = os.path.splitext
basename = os.path.basename


def join(*paths):
    return '/'.join(paths)


def exists(path):
    path = path.replace("\\", "/")
    try:
        getFile(path, type=BY_PATH)
        return True
    except FileNotFoundError:
        return False


def getctime(filename, property=None, subProperty=None, timeFormat=None):
    """
    Get creation time or specified property time of a file.

    @param filename The file to get creation time or photo time.
    @param property, subProperty The specified properties to get file's ctime.
    @return Datetime object of the files creation time or specified property.
    """

    # pre-process params
    filename = filename.replace("\\", "/")
    property = "createdTime" if property is None else property
    file = getFile(filename, type=BY_PATH, fields=[property])

    # find time string
    propertyDict = file.get(property)
    if propertyDict is not None:
        if subProperty is not None:
            if propertyDict.get(subProperty) is not None:
                result = propertyDict.get(subProperty)
            else:
                raise AttributeError()
        else:
            result = propertyDict
    else:
        raise AttributeError()

    if timeFormat is not None:
        return datetime.datetime.strptime(result, timeFormat)
    else:
        return parser.parse(result)
