#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: __init__.py 9716 2017-01-13 13:24:44Z Lavender $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $ (last)
# $Date: 2017-01-13 21:24:44 +0800 (Fri, 13 Jan 2017) $
# $Revision: 9716 $

import os
import sys
import warnings

from Iuno import warnWithout, update, require
from Iuppiter.DjangoUtil import (extendInstalledApps, 
                                 extendMiddlewareClasses, 
                                 extendTemplateContextProcessors,
                                 extendTemplateDirs, 
                                 extendDatabaseDefaults, 
                                 extendAuthenticationBackend)

from oscar import get_core_apps
from oscar import OSCAR_MAIN_TEMPLATE_DIR
from oscar.defaults import *

def attachSettings(settingsDict, enablePaypal=False):
    """
    Attach default settings to settings.py.
    It must be called in settings by passing locals().

    @param settingsDict locals() in settings.py.
    @param enablePaypal enable pay with paypal or not
    """

    BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))

    #=========================================================================
    # Django plugins.

    ADDING_INSTALLED_APPS = (
        'django.contrib.flatpages',
        'compressor',
        'widget_tweaks',
        'paypal',
    ) + tuple(get_core_apps())
    
    ADDING_MIDDLEWARE_CLASSES = (
        'oscar.apps.basket.middleware.BasketMiddleware',
        'django.contrib.flatpages.middleware.FlatpageFallbackMiddleware',
    )

    installed = settingsDict['INSTALLED_APPS']
    keys = [k for k in installed if k.startswith('django.contrib')]
    extendInstalledApps(settingsDict, ADDING_INSTALLED_APPS,
                        key=list(keys)[-1])

    extendMiddlewareClasses(settingsDict, ADDING_MIDDLEWARE_CLASSES,
                            key='django.middleware.security.SecurityMiddleware')
    #=========================================================================
    
    #=========================================================================
    # Email.
    emailDefaults = {
        'ACCOUNT_EMAIL_CONFIRMATION_REQUIRED' : True,
        'EMAIL_BACKEND' : 'django.core.mail.backends.smtp.EmailBackend',
    }
    
    warnWithout('EMAIL_BACKEND', settingsDict, emailDefaults)

    update(settingsDict, emailDefaults)
    #=========================================================================
    
    #=========================================================================
    # authentication backends.
    authenticationBackends = [            
        'django.contrib.auth.backends.ModelBackend',
        'oscar.apps.customer.auth_backends.EmailBackend',
    ]

    authenticationBackends = tuple(authenticationBackends)
    
    extendAuthenticationBackend(settingsDict, authenticationBackends)
    #=========================================================================
    
    #=========================================================================
    #  Django templates.
    #  Context processors
    ADDING_TEMPLATES_CONTEXT_PROCESSORS = (
        'oscar.apps.search.context_processors.search_form',
        'oscar.apps.promotions.context_processors.promotions',
        'oscar.apps.checkout.context_processors.checkout',
        'oscar.apps.customer.notifications.context_processors.notifications',
        'oscar.core.context_processors.metadata',                       
    )
    
    extendTemplateContextProcessors(settingsDict, 
                                    ADDING_TEMPLATES_CONTEXT_PROCESSORS)

    # Template tags
    ADDING_TEMPLATES_DIRS = [
        os.path.join(BASE_DIR, 'templates'),
        OSCAR_MAIN_TEMPLATE_DIR,
    ]
    extendTemplateDirs(settingsDict, ADDING_TEMPLATES_DIRS)
    #=========================================================================
    # Django database default values.
    ADDING_DATABASES_DEFAULTS = {
        'ATOMIC_REQUESTS': True
    }
    extendDatabaseDefaults(settingsDict, ADDING_DATABASES_DEFAULTS)
    #=========================================================================
    # Django haystack connections.
    HAYSTACK_CONNECTIONS = {
        'default': {
            'ENGINE': 'haystack.backends.simple_backend.SimpleEngine',
        },
    }
    update(settingsDict, HAYSTACK_CONNECTIONS)
    #=========================================================================
    # Oscar default currency
    OSCAR_DEFAULT_CURRENCY = 'USD'
    #=========================================================================
    if enablePaypal:
        pass
