#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: __init__.py 11172 2018-07-16 09:31:00Z Lavender $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $ (last)
# $Date: 2018-07-16 18:31:00 +0900 (週一, 16 七月 2018) $
# $Revision: 11172 $

from django.contrib import auth
from Iuppiter.Service import BaseService

from Iuppiter.Model import ServiceManager

class AbstractMemberService(BaseService):
    """
    Service to provide member related API.
    """
    def __init__(self):
        """
        Constructor.
        """
        super(AbstractMemberService, self).__init__((auth.models,))

     
    def createUser(self, _obj=None, **kws):
        if _obj:
            _obj.save()
            return _obj
        else:
            return auth.models.User.objects.create_user(**kws)

