#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: FixTemplateTest.py 11055 2018-05-14 09:46:32Z Lavender $
#
# Copyright (c) 2020 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2018-05-14 17:46:32 +0800 (週一, 14 五月 2018) $
# $Revision: 11055 $

import unittest
import logging

logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)
handler = logging.StreamHandler()
handler.setFormatter(
    logging.Formatter("%(asctime)s - %(levelname)s - %(message)s"))
logger.addHandler(handler)

from Zephyrus.facebook.cms_plugins import getFanPage, getFanPhoto

class FanPageTest(unittest.TestCase):

    FAN_PAGE_URL = "https://www.facebook.com/nuwainfo/"
    FAN_PHOTO_URL = "https://www.facebook.com/pg/nuwainfo/photos/?tab=album&album_id=398872387250345&ref=page_internal"
    LIMIT = 0
    
    def testFanPage(self):
        pages = getFanPage(self.FAN_PAGE_URL, self.LIMIT)
        self.assertEqual(len(pages), 19)
        return
        
    def testFanPhoto(self):
        photos = getFanPhoto(self.FAN_PHOTO_URL, self.LIMIT)
        self.assertEqual(len(photos), 1)
        return
        
        
if __name__ == '__main__':
    unittest.main()
    