#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: LandingSocial.py 10323 2017-09-26 10:41:04Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-09-26 18:41:04 +0800 (週二, 26 九月 2017) $
# $Revision: 10323 $

from django import template
from django.utils.safestring import mark_safe
from django.core.urlresolvers import reverse
from djangocms_forms.utils import int_to_hashid

register = template.Library()

@register.simple_tag
def LandingSocial(request, method, redirectTo=None, form=None):
    social = reverse('social:begin', args=[method])
    fromUrl = request.path 
    next = "?next=%s?fromUrl=%s" % (reverse('landing_social'), fromUrl)
    if redirectTo:
        next += ("%26redirectTo=" + redirectTo)
    url = social + next
    if form:
        url = url + "%26formId=" + int_to_hashid(form.pk)
    return mark_safe(url)
