#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: admin.py 11569 2019-05-21 20:41:08Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2019-05-22 05:41:08 +0900 (週三, 22 五月 2019) $
# $Revision: 11569 $

import six
import urllib

from django.contrib import admin

from Iuppiter.Encoding import utf8

from Zephyrus.statistics import views
from Zephyrus.statistics.models import URL

@admin.register(URL)
class URLAdmin(admin.ModelAdmin):
    model = URL

    list_display = ['getUrl', 'viewCount', 'likeCount', 'commentCount']
    
    def getUrl(self, obj):
        if six.PY3:
            name = urllib.parse.unquote(str(obj.url))
        else:
            name = urllib.unquote(str(obj.url))
            
        name = utf8(name).decode('utf8')
         
        return u"<a target='_blank' href='%s'>%s</a>" % (obj.url, name)

    getUrl.short_description = "URL"
    getUrl.admin_order_field = 'url'
    getUrl.allow_tags = True
