#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: admin.py 11569 2019-05-21 20:41:08Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2019-05-22 05:41:08 +0900 (週三, 22 五月 2019) $
# $Revision: 11569 $

from __future__ import unicode_literals

from django.db import migrations, models
from django.conf import settings

if hasattr(settings, 'ZEPHYRUS_BLOG_ENABLE'):
    ZEPHYRUS_BLOG_ENABLE = settings.ZEPHYRUS_BLOG_ENABLE
else:
    ZEPHYRUS_BLOG_ENABLE = False

def moveViewCount(apps, schemaEditor):
    try:
        # 如果有 blog_extension.models.ViewCount
        ViewCount = apps.get_model('blog_extension', 'ViewCount')
        URL = apps.get_model('statistics', 'URL')
        for vc in ViewCount.objects.all():
            url = URL.objects.create(
                id=vc.id,
                url=vc.url,
                viewCount=vc.count,
            )
            url.save()
    except:
        # do nothing
        pass


class Migration(migrations.Migration):

    if ZEPHYRUS_BLOG_ENABLE:
        dependencies = [
            ('blog_extension', '0008_auto_20190522_0409'),
        ]
    else:
        dependencies = [
        ]

    operations = [
        migrations.CreateModel(
            name='URL',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('url', models.CharField(max_length=400, editable=False)),
                ('viewCount', models.PositiveIntegerField(default=0)),
                ('likeCount', models.PositiveIntegerField(default=0)),
                ('commentCount', models.PositiveIntegerField(default=0)),
            ],
        ),
        migrations.RunPython(moveViewCount),
    ]
