#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: models.py 11569 2019-05-21 20:41:08Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2019-05-22 05:41:08 +0900 (週三, 22 五月 2019) $
# $Revision: 11569 $

from django.db import models
from django.utils.translation import ugettext_lazy as _

class URL(models.Model):
    url = models.CharField(max_length=400, editable=False)
    viewCount = models.PositiveIntegerField(
        verbose_name=_("View count"), default=0)
    likeCount = models.PositiveIntegerField(
        verbose_name=_("Like count"), default=0)
    commentCount = models.PositiveIntegerField(
        verbose_name=_("Comment count"), default=0)
