#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: configure.py 105 2016-12-24 02:07:51Z Lavender $
#
# Copyright (c) 2016 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2016-12-24 10:07:51 +0800 (週六, 24 十二月 2016) $
# $Revision: 105 $

import os
import sys
import datetime

from django.core.management.base import BaseCommand, CommandError
from django.template.loader import get_template
from django.template import Context

class Command(BaseCommand):
    
    help = 'Build django project with our settting and files.'
    
    def add_arguments(self, parser):
        parser.add_argument('name', type=str, help="Project name")
        parser.add_argument('path', type=str, help="Project path")
    
    def handle(self, *args, **options):
        path = options['path']
        name = options['name']

        path = os.path.join(path, options['name'])
        os.mkdir(path)

        import django
        if not (django.VERSION[0] == 1 and django.VERSION[1] == 8):
            raise CommandError("Only support django 1.8.x")

        # FIXME: 判斷 Manage.py
        os.system(
            "%s manage.py startproject %s %s" % (sys.executable,  name, path))

        settingPath = os.path.join(path, name, 'settings.py')
        urlPath = os.path.join(path, name, 'urls.py')

        def renderFile(template, path, fileName, linux=False):
            temp = get_template(template)
            content = temp.render()
            
            if linux:
                with open(os.path.join(path, fileName), 'wb') as f:
                    f.write(content.replace('\r\n', '\n'))
            else:
                with open(os.path.join(path, fileName), 'w') as f:
                    f.write(content)

        # file -----------------------------------------------------------------
        renderFile('scaffold/Activate.bat', path, 'Activate.bat')      
        renderFile('scaffold/Configure.bat', path, 'Configure.bat')
        renderFile('scaffold/Configure.sh', path, 'Configure.sh', linux=True)   
        renderFile('scaffold/README.txt', path, 'README.txt')    
        renderFile('scaffold/REQUIREMENTS.txt', path, 'REQUIREMENTS.txt') 

        # Settings.py ----------------------------------------------------------
        with open(settingPath, 'r') as setting:
            content = setting.read()

        # Header
        context = Context({
            "year": datetime.date.today().year, 
        })
        temp = get_template('scaffold/HeaderTemplate.py')
        header = temp.render(context)
        content = header + content

        # debug & mode
        context = Context({
            "name": name.lower(), 
        })
        temp = get_template('scaffold/DebugTemplate.py')
        debug = temp.render(context)
        content = content.replace('DEBUG = True', debug)

        # allow host
        temp = get_template('scaffold/AllowHostTemplate.py')
        host = temp.render(context)
        content = content.replace('ALLOWED_HOSTS = []', host)

        # db & static
        temp = get_template('scaffold/Database.py')
        database = temp.render()
        content = content.replace(database, '')

        temp = get_template('scaffold/Static.py')
        static = temp.render()
        content = content.replace(static, '')

        temp = get_template('scaffold/TimeZone.py')
        timeZone = temp.render()
        content = content.replace(timeZone, '')

        # Footer
        temp = get_template('scaffold/FooterTemplate.py')
        footer = temp.render()
        content = content + footer

        with open(settingPath, 'wb') as setting:
            setting.write(content.replace('\r\n', '\n'))

        # Urls.py --------------------------------------------------------------
        with open(urlPath, 'r') as url:
            content = url.read()

        temp1 = get_template('scaffold/Urls.py').render()
        temp2 = get_template('scaffold/UrlsTemplate.py').render()
        content = content.replace(temp1, temp2)

        with open(urlPath, 'w') as url:
            url.write(content)

             

        
