#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: __init__.py 13367 2021-12-24 04:53:31Z Mint $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Mint $
# $Date: 2021-12-24 12:53:31 +0800 (週五, 24 十二月 2021) $
# $Revision: 13367 $

from django.conf.urls import url, include

from Iuppiter.DjangoUtil import DJANGO_VERSION

def patterns(prefix, *args): 
    if DJANGO_VERSION >= 11100: # django >= 1.11
        return list(args)
    else:
        from django.conf.urls import patterns as _patterns
        
        return _patterns(prefix, *args)

def attachURLs(settings, urlpatterns):
    """
    Attach patched (for example, debug and admin...etc.) urlpatterns.
    It must be called in urls.py by passing urlpatterns.

    @param settings Django project's settings module.
    @param urlpatterns urlpatterns in urls.py.
    """
    urlpatterns += patterns('',
        url(r'^', include('Zephyrus.landing.urls')),
        #FIXME: unknown reason have to add a blank (or anything else) behind to make this url works.
        url(r'^ ', include('djangocms_forms.urls')),
    )

class ErrorCode(object):
    NORMAL = 0
    SAVE_EMAIL = 1
    SEND_EMAIL = 2
    EMAIL_FORMAT = 3