/**
$Id: Newsletter_en-us.js 9579 2016-03-09 01:43:46Z Judy $

Copyright (c) 2012 Nuwa Information Co., Ltd, All Rights Reserved.

Licensed under the Proprietary License, 
you may not use this file except in compliance with the License.
You may obtain a copy of the License at our web site.

See the License for the specific language governing permissions and
limitations under the License.

$Author: Judy $
$Date: 2016-03-09 09:43:46 +0800 (三, 09  3 2016) $
$Revision: 9579 $
*/

var $ = django.jQuery;
$().ready(function() {
    var $sender = $('#id_header_sender');
    $sender.attr('size', '60');
    $('#id_header_reply').attr('size', '60');
    
    var parent = $sender.parent();
    $(parent).append(
        '<p name="cloudHelp" class="help">Please give a sender, example: ' +
        'Name&lt;E-mail address&gt;. Your email address needed to verify.</p>');
    $(parent).append(
        '<p name="cloudHelp" class="help">' +
        '<a id="verify" href="javascript:void(0);">Verify</a> | ' +
        '<a id="deleteVerification" href="javascript:void(0);">' + 
        'Delete verification</a></p>');
    
    var $serverSelectBox = $('#id_server');
    var showVerificationButtons = function(target) {
        if ($(target).val() == 1) { // Select Cloud SMTP Server.
            $('[name=cloudHelp]').show();
        }
        else {
            $('[name=cloudHelp]').hide();
        }
    };
    
    $serverSelectBox.change(function() {
        console.log('change serverSelectBox');
        showVerificationButtons($(this));
    });
    
    $('#verify').click(function() {
        $.ajax({
            type: "GET",
            data: {email: $sender.val()},
            url: '/newsletters/plus/cloud/verify',
            dataType: "jsonp",
            jsonp: "jsonpcallback",
            crossDomain: true,
            success: function (response) {
                if (response.verification) {
                    alert(response.message);
                }
                else {
                    alert(response.message);
                }
            },
            error: function() {
                ;
            }
        });
    });
    
    $('#deleteVerification').click(function() {
        $.ajax({
            type: "GET",
            data: {email: $sender.val()},
            url: '/newsletters/plus/cloud/verify/delete',
            dataType: "jsonp",
            jsonp: "jsonpcallback",
            crossDomain: true,
            success: function (response) {
                if (response.verification) {
                    alert(response.message);
                }
                else {
                    alert(response.message);
                }
            },
            error: function() {
                ;
            }
        });
    });

    showVerificationButtons($serverSelectBox);

    // Hide save button.
    $('#newsletter_form [type=submit]').hide();
    var $submitRow = $('#newsletter_form .submit-row');
    // Insert checking div.
    $('<div id="loadingDiv" class="submit-row">Checking...</div>').insertAfter($submitRow);
    $('#loadingDiv').hide();
    
    var hasVerified = function(email, btnTarget) {
        $.ajax({
            type: "GET",
            data: {email: email},
            url: '/newsletters/plus/cloud/verify/check',
            dataType: "jsonp",
            jsonp: "jsonpcallback",
            crossDomain: true,
            success: function (response) {
                if (response.verification) {
                    btnTarget.click();
                }
                else {
                    alert(response.message);
                }
                $submitRow.show();
                $('#loadingDiv').hide();
            },
            error: function() {
                ;
            }
        });
    };
    
    $submitRow.append('<input type="button" id="check" class="default" value="Save" />');
    $submitRow.append('<input type="button" id="continue" class="default" value="Save and continue" />');
    $submitRow.append('<input type="button" id="addAnother" class="default" value="Save and add another" />');
    
    $('#check').click(function() {
        $submitRow.hide();
        $('#loadingDiv').show();
        hasVerified($sender.val(), $('#newsletter_form [name=_save]'));
    });
    
    $('#continue').click(function() {
        $submitRow.hide();
        $('#loadingDiv').show();
        hasVerified($sender.val(), $('#newsletter_form [name=_continue]'));
    });
    
    $('#addAnother').click(function() {
        $submitRow.hide();
        $('#loadingDiv').show();
        hasVerified($sender.val(), $('#newsletter_form [name=_addanother]'));
    });
    
});
