# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models

def changeType(apps, schemaEditor):
    Static = apps.get_model('template_editor', 'Static')
    Template = apps.get_model('template_editor', 'Template')
    
    for static in Static.objects.all():
        if static.type == 'folder':
            static.type = 1 # folder id
        else:
            static.type = 2 # file id
        static.save()
            
    for template in Template.objects.all():
        if template.type == 'folder':
            template.type = 1 # folder id
        else:
            template.type = 2 # file id
        template.save()

class Migration(migrations.Migration):

    dependencies = [
        ('template_editor', '0002_version'),
    ]

    operations = [
        migrations.RunPython(changeType),
        migrations.AlterField(
            model_name='static',
            name='type',
            field=models.IntegerField(max_length=1, choices=[(1, b'File'), (2, b'Folder')]),
        ),
        migrations.AlterField(
            model_name='template',
            name='type',
            field=models.IntegerField(max_length=1, choices=[(1, b'File'), (2, b'Folder')]),
        ),
    ]
