from __future__ import unicode_literals

from selectable.base import ModelLookup
from selectable.registry import registry

from Theophrastus.models import Newsletter

class SenderLookup(ModelLookup):
    model = Newsletter
    search_fields = ('header_sender__icontains', )

    def get_item_value(self, item):
        return item.header_sender

    def get_item_label(self, item):
        return item.header_sender

    def format_results(self, raw_data, options):
        results = super(SenderLookup, self).format_results(raw_data, options)
        results['data'] = {v['value']:v for v in results['data']}.values()
        return results

class ReplyLookup(ModelLookup):
    model = Newsletter
    search_fields = ('header_reply__icontains', )

    def get_item_value(self, item):
        return item.header_reply

    def get_item_label(self, item):
        return item.header_reply

    def format_results(self, raw_data, options):
        results = super(ReplyLookup, self).format_results(raw_data, options)
        results['data'] = {v['value']:v for v in results['data']}.values()
        return results

registry.register(SenderLookup)
registry.register(ReplyLookup)
