#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: Local.py 9439 2015-09-25 08:01:30Z Eric $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Eric $ (last)
# $Date: 2015-09-25 16:01:30 +0800 (週五, 25 九月 2015) $
# $Revision: 9439 $

from Iuno.cloud.backend import Local
from Iuno.cloud.queue.backend import BackendMixin, CeleryBrokerInfo

class Backend(Local.Backend, BackendMixin):

    def _getDefaultConfig(self):
        return {
            'BROKER_PORT': CeleryBrokerInfo.BROKER_PORT,
            'BROKER_USER': CeleryBrokerInfo.BROKER_USER,
            'BROKER_PASSWORD': CeleryBrokerInfo.BROKER_PASSWORD,
            'BROKER_VHOST': CeleryBrokerInfo.BROKER_VHOST,
            'CELERY_REDIS_PORT': CeleryBrokerInfo.REDIS_PORT,
            'CELERY_REDIS_PASSWORD': CeleryBrokerInfo.REDIS_PASSWORD,
            'HOST_OS': 'linux',
        }

    def _cast(self, key, value):
        if key in ('BROKER_PORT', 'CELERY_REDIS_PORT'):
            return int(value)

        return value

    def getCeleryBrokerInfo(self, preferred=None):
        domains = self.getDomains(preferred)
        for domain in domains:
            if self._checkStatus(domain, self.CELERY_BROKER_SERVICES):
                return CeleryBrokerInfo(domain, config=self.domains[domain])
        return None
