#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: __init__.py 10999 2018-04-30 07:30:23Z Lavender $
#
# Copyright (c) 2018 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $ (last)
# $Date: 2018-04-30 15:30:23 +0800 (週一, 30 四月 2018) $
# $Revision: 10999 $

import hashlib

from collections import OrderedDict
from urllib import urlencode

class Pay2GoMPGAPI(object):

    def __init__(self, hashKey, hashIv, sandbox, *args, **kwargs):
        self.hashKey = hashKey
        self.hashIv = hashIv
        if sandbox:
            self.ApiUrl = 'https://ccore.spgateway.com/MPG/mpg_gateway'
        else:
            self.ApiUrl = 'https://core.spgateway.com/MPG/mpg_gateway'

        self.requiredFields = (
            'Amt',
            'MerchantID',
            'MerchantOrderNo',
            'TimeStamp',
            'Version',
        )

    def buildFormData(self, data):
        def generateCheckValue(data):
            orderedDict = OrderedDict()

            orderedDict['HashKey'] = self.hashKey
            for field in self.requiredFields:
                orderedDict[field] = data[field]
            orderedDict['HashIV'] = self.hashIv

            checkValue = hashlib.sha256(
                urlencode(orderedDict).encode('utf-8')).hexdigest().upper()

            return checkValue

        formData = dict(data)
        formData['CheckValue'] = generateCheckValue(data)

        return formData

    def createPayment(self, data):
        payment = Payment(
            formAction=self.ApiUrl,
            formData=self.buildFormData(data)
        )

        return payment


class Payment(object):

    def __init__(self, formAction, formData, *args, **kwargs):
        self.formAction = formAction
        self.formData = formData