#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: UtilTest.py 10926 2018-03-26 07:30:32Z Kevin $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Kevin $ (last)
# $Date: 2018-03-26 15:30:32 +0800 (週一, 26 三月 2018) $
# $Revision: 10926 $

import unittest

from Iuno import Util

class UtilTest(unittest.TestCase):
    """
    Test case for Util.
    """

    def testVersionInfo(self):
        """
        Test for VersionInfo class.
        """
        v1 = Util.VersionInfo('0.1.0.2137')
        v2 = Util.VersionInfo('0.2.0.4444')

        self.assertTrue(v1 < v2)
        self.assertFalse(v1 > v2)
        self.assertFalse(v1 == v2)

        self.assertTrue(v1 == v1)
        self.assertTrue(v2 == v2)

        self.assertTrue(v1 < '0.1.0.2138')
        self.assertTrue(v1 == '0.1.0.2137')

        # Wildcard
        self.assertTrue(v1 < '0.1.1.?')
        self.assertTrue(v1 < '0.*.2.?')

        v3 = Util.VersionInfo('0.2.1.56789')
        self.assertTrue(v3 > v2 and v3 > v1)
        self.assertTrue(v3 > '0.*.0.?')
        self.assertTrue(v3 < '1.*.?.?')
        self.assertTrue(Util.VersionInfo('0.1.1.*') == '0.1.1.?')

        self.assertEqual(str(v1), '0.1.0.2137')
        self.assertEqual(str(v2), '0.2.0.4444')

        self.assertEqual(v1, '0.1.0.2137')

        self.assertEqual('v: %s' % v1, 'v: 0.1.0.2137')
        self.assertEqual('v: %s' % v3, 'v: 0.2.1.56789')

if __name__ == '__main__':
    unittest.main()
