#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: views.py 10806 2018-03-02 04:29:05Z David $
#
# Copyright (c) 2012 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: David $
# $Date: 2018-03-02 12:29:05 +0800 (週五, 02 三月 2018) $
# $Revision: 10806 $

import os

from django.shortcuts import HttpResponse
from django.template.loader import render_to_string
from django.utils.translation import ugettext as _
from django.conf import settings
from django.contrib.admin.views.decorators import staff_member_required

from Iuppiter.extension.views import view, jsonpCallback

TEMPLATE_DIR_PATH = settings.TEMPLATE_DIR_PATH

def getTemplate(request, name):
    """
    Get template.

    @param name Template name.
    @param request Request instance.
    """
    c = render_to_string(
        '%s%s.html' % (TEMPLATE_DIR_PATH, name.title()),
        {'MEDIA_URL': settings.MEDIA_URL}
    )
    return HttpResponse(c)

class FileExistException(Exception):
    def __init__(self, path):
        self.path = path

    def __str__(self):
        return _('File has exist, path: %s') % self.path

from django import forms

class UploadFileForm(forms.Form):
    #title = forms.CharField(max_length=50, required=False)
    file = forms.FileField()

def handleUploadedFile(f):
    """
    # Imaginary function to handle an uploaded file.
    """
    rootPath = settings.UPLOAD_PATH
    destination = None
    filePath = ''
    try:
        destinationPath = os.path.join(rootPath, f.name)
#        if os.path.exists(destinationPath):
#            raise FileExistException(destinationPath)

        destination = open(destinationPath, 'wb')
        for chunk in f.chunks():
            destination.write(chunk)

        filePath = settings.MEDIA_URL + 'uploads/%s' % f.name
    finally:
        if destination:
            destination.close()
    return filePath

@staff_member_required
@jsonpCallback(noPadding=True)
def upload(request):
    """
    Upload a file.

    @param request Request instance.
    """
    message = ''
    formError = {}
    if request.method == 'POST':
        try:
            form = UploadFileForm(request.POST, request.FILES)
            if form.is_valid():
                filePath = handleUploadedFile(request.FILES['file'])
                return {'result': True, 'file': filePath}
            else:
                for name in form.errors:
                    strings = []
                    for error in form.errors[name]:
                        strings.append(error)
                    formError[name] = strings
        except FileExistException as e:
            message = str(e)
        except Exception as e:
            message = str(e)

    return {'result': False, 'errors': {'message': message, 'form': formError}}

@staff_member_required
@view('Upload.html')
def uploadFile(request):
    """
    Display upload page.

    @param request Request instance.
    """
    return {
        'form': UploadFileForm(),
        'extra': range(settings.UPLOAD_EXTRA),
    }

@view('FeedComplete.html')
def feedComplete(request):
    """
    Redirect to this view when feed completed.

    If feed successfully, we will get a argument "post_id".
    Sample: post_id=100000187377979_135405309958471

    @param request Request instance.
    """
    postId = request.GET.get('post_id', '')
    return {'postId': postId}
