#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: setup.py 15025 2024-10-19 10:32:41Z Tim $
#
# Copyright (c) 2024 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Tim $
# $Date: 2024-10-19 18:32:41 +0800 (週六, 19 十月 2024) $
# $Revision: 15025 $

from setuptools import setup, find_packages
from setuptools.command.install import install
import os
import stat

PACKAGE_NAME = "wasm_file_http"

class PostInstallCommand(install):
    def run(self):
        install.run(self)
        compileFileNames = ["wat2wasm", "wasm2wat"]
        for fileName in compileFileNames:
            filePath = os.path.join(self.install_lib, PACKAGE_NAME, 'wabt', 'bin', fileName)
            st = os.stat(filePath)
            os.chmod(filePath, st.st_mode | stat.S_IEXEC)

with open('REQUIREMENTS.txt', encoding="utf8") as f:
    requirements = f.read().splitlines()

with open('README.txt', encoding="utf8") as f:
    description = f.read()

setup(
    name="wasm_file_http",
    version="0.2.1",
    packages=find_packages(),
    install_requires=requirements,
    package_data={"wasm_file_http": ["wabt/bin/*"]},
    include_package_data=True,
    cmdclass={
        'install': PostInstallCommand,
    },
    author="Tim",
    author_email="tim.lai@nuwainfo.com",
    description="Proxy HTTP support for wasmtime runtime",
    long_description=description,
    long_description_content_type='text/markdown',
    # url="https://github.com/yourusername/my_package",
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ],
    python_requires='>=3.11',
)
