#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: APIClient.py 14896 2024-09-11 04:21:02Z Tim $
#
# Copyright (c) 2024 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Tim $
# $Date: 2024-09-11 12:21:02 +0800 (週三, 11 九月 2024) $
# $Revision: 14896 $

import requests
import json
import logging
import time
from wasm_file_http.DataTypes import GETConfig, POSTConfig

logger = logging.getLogger(__name__)

class FileAPIClient:

    @classmethod
    def sendGETRequest(cls, config: GETConfig) -> str:
        # logger.debug("sending request ...\n")
        try:
            response = requests.get(
                url=config.url,
                headers=config.headers,
                params=config.params,
                timeout=config.timeout,
            )
            result = {
                "status_code": response.status_code,
                "data": response.json()
            }
            return json.dumps(result, indent=4)

        except requests.exceptions.Timeout:
            return json.dumps(
                {
                    "status_code": 401,
                    "message": "request timeout"
                }
            )

        except Exception as e:
            logger.warning(str(e), exc_info=True)
            return json.dumps({
                "status_code": response.status_code,
                "message": response.text
            })

    @classmethod
    def sendPostRequest(cls, config: POSTConfig) -> str:
        # logger.debug("sending request ...\n")
        try:
            response = requests.post(
                url=config.url,
                headers=config.headers,
                data=config.data,
                timeout=config.timeout,
                json=config.json
            )
            try:
                data = response.json()
            except requests.exceptions.JSONDecodeError:
                data = response.text  # Fallback to raw text if JSON decoding fails

            result = {"status_code": response.status_code, "data": data}
            return json.dumps(result, indent=4)

        except requests.exceptions.Timeout:
            return json.dumps(
                {
                    "status_code": 401,
                    "message": "request timeout"
                }
            )

        except requests.exceptions.ConnectionError as e:
            logger.warning(str(e), exc_info=True)
            return json.dumps({
                "message": f"{str(e)}"
            })

        except Exception as e:
            logger.warning(str(e), exc_info=True)
            return json.dumps({
                "status_code": response.status_code,
                "message": response.text
            })

