#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: DataTypes.py 14716 2024-07-18 11:19:22Z Tim $
#
# Copyright (c) 2024 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Tim $
# $Date: 2024-07-18 19:19:22 +0800 (週四, 18 七月 2024) $
# $Revision: 14716 $

from dataclasses import dataclass
from typing import Optional
from enum import IntEnum

@dataclass(frozen=True)
class BaseRequstConfig:
    url: str
    headers: dict
    timeout: int

@dataclass(frozen=True)
class GETConfig(BaseRequstConfig):
    params: Optional[dict] = None

@dataclass(frozen=True)
class POSTConfig(BaseRequstConfig):
    data: Optional[dict] = None
    json: Optional[dict] = None

class WasmResultStatus(IntEnum):
    SUCCESS = 1
    ERROR = 2
